<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\ArrayType\ArrayOfKeyValueOfstringstring $context, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named SendRelationshipInvitation
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\SendRelationshipInvitation_Request $iCrmFacade_SendRelationshipInvitation_RequestMsg
     * @return \patest\StructType\SendRelationshipInvitation_Response|bool
     */
    public function SendRelationshipInvitation(\patest\StructType\SendRelationshipInvitation_Request $iCrmFacade_SendRelationshipInvitation_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->SendRelationshipInvitation($iCrmFacade_SendRelationshipInvitation_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendBasketToPrint
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\SendBasketToPrint_Request $iPrintingFacade_SendBasketToPrint_RequestMsg
     * @return \patest\StructType\SendBasketToPrint_Response|bool
     */
    public function SendBasketToPrint(\patest\StructType\SendBasketToPrint_Request $iPrintingFacade_SendBasketToPrint_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->SendBasketToPrint($iPrintingFacade_SendBasketToPrint_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendBasketToPrintStandalone
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\SendBasketToPrintStandalone_Request $iPrintingFacade_SendBasketToPrintStandalone_RequestMsg
     * @return \patest\StructType\SendBasketToPrintStandalone_Response|bool
     */
    public function SendBasketToPrintStandalone(\patest\StructType\SendBasketToPrintStandalone_Request $iPrintingFacade_SendBasketToPrintStandalone_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->SendBasketToPrintStandalone($iPrintingFacade_SendBasketToPrintStandalone_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendAdHocDocumentsToPrint
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\SendAdHocDocumentsToPrint_Request $iPrintingFacade_SendAdHocDocumentsToPrint_RequestMsg
     * @return \patest\StructType\SendAdHocDocumentsToPrint_Response|bool
     */
    public function SendAdHocDocumentsToPrint(\patest\StructType\SendAdHocDocumentsToPrint_Request $iPrintingFacade_SendAdHocDocumentsToPrint_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->SendAdHocDocumentsToPrint($iPrintingFacade_SendAdHocDocumentsToPrint_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendBasketSalesBatchToPrint
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\SendBasketSalesBatchToPrint_Request $iPrintingFacade_SendBasketSalesBatchToPrint_RequestMsg
     * @return \patest\StructType\SendBasketSalesBatchToPrint_Response|bool
     */
    public function SendBasketSalesBatchToPrint(\patest\StructType\SendBasketSalesBatchToPrint_Request $iPrintingFacade_SendBasketSalesBatchToPrint_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->SendBasketSalesBatchToPrint($iPrintingFacade_SendBasketSalesBatchToPrint_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendFollowUpBasketToPrint
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\SendFollowUpBasketToPrint_Request $iPrintingFacade_SendFollowUpBasketToPrint_RequestMsg
     * @return \patest\StructType\SendFollowUpBasketToPrint_Response|bool
     */
    public function SendFollowUpBasketToPrint(\patest\StructType\SendFollowUpBasketToPrint_Request $iPrintingFacade_SendFollowUpBasketToPrint_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->SendFollowUpBasketToPrint($iPrintingFacade_SendFollowUpBasketToPrint_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\SendAdHocDocumentsToPrint_Response|\patest\StructType\SendBasketSalesBatchToPrint_Response|\patest\StructType\SendBasketToPrintStandalone_Response|\patest\StructType\SendBasketToPrint_Response|\patest\StructType\SendFollowUpBasketToPrint_Response|\patest\StructType\SendRelationshipInvitation_Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
