<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Run ServiceType
 * @subpackage Services
 */
class Run extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\ArrayType\ArrayOfKeyValueOfstringstring $context, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named RunBatchProcess
     * This method has been renamed because it is defined several times but with
     * different signature
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\DonaitonRunBatchProcessRequest $iDonationFacade_RunBatchProcess_RequestMsg
     * @return \patest\StructType\DonationRunBatchProcessResponse|bool
     */
    public function RunBatchProcess(\patest\StructType\DonaitonRunBatchProcessRequest $iDonationFacade_RunBatchProcess_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->RunBatchProcess($iDonationFacade_RunBatchProcess_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RunBatchProcess
     * This method has been renamed because it is defined several times but with
     * different signature
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\MembershipRunBatchProcessRequest $iMembershipFacade_RunBatchProcess_RequestMsg
     * @return \patest\StructType\MembershipRunBatchProcessResponse|bool
     */
    public function RunBatchProcess_327b3578629ac6b65e8d8d457a6e3288(\patest\StructType\MembershipRunBatchProcessRequest $iMembershipFacade_RunBatchProcess_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->RunBatchProcess($iMembershipFacade_RunBatchProcess_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\DonationRunBatchProcessResponse|\patest\StructType\MembershipRunBatchProcessResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
