<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Retrieve ServiceType
 * @subpackage Services
 */
class Retrieve extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\ArrayType\ArrayOfKeyValueOfstringstring $context, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named RetrieveCustomer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\RetrieveCustomerRequest $iCrmFacade_RetrieveCustomer_RequestMsg
     * @return \patest\StructType\RetrieveCustomerResponse|bool
     */
    public function RetrieveCustomer(\patest\StructType\RetrieveCustomerRequest $iCrmFacade_RetrieveCustomer_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveCustomer($iCrmFacade_RetrieveCustomer_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveAccount
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\RetrieveAccountRequest $iCrmFacade_RetrieveAccount_RequestMsg
     * @return \patest\StructType\RetrieveAccountResponse|bool
     */
    public function RetrieveAccount(\patest\StructType\RetrieveAccountRequest $iCrmFacade_RetrieveAccount_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveAccount($iCrmFacade_RetrieveAccount_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveClientPurchases
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\RetrieveClientPurchasesRequest $iCrmFacade_RetrieveClientPurchases_RequestMsg
     * @return \patest\StructType\RetrieveClientPurchasesResponse|bool
     */
    public function RetrieveClientPurchases(\patest\StructType\RetrieveClientPurchasesRequest $iCrmFacade_RetrieveClientPurchases_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveClientPurchases($iCrmFacade_RetrieveClientPurchases_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveSalesItems
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\RetrieveSalesItemsRequest $iProductSalesFacade_RetrieveSalesItems_RequestMsg
     * @return \patest\StructType\RetrieveSalesItemsResponse|bool
     */
    public function RetrieveSalesItems(\patest\StructType\RetrieveSalesItemsRequest $iProductSalesFacade_RetrieveSalesItems_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveSalesItems($iProductSalesFacade_RetrieveSalesItems_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveHallVersionDesign
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\RetrieveHallVersionDesign_Request $iTicketingFacade_RetrieveHallVersionDesign_RequestMsg
     * @return \patest\StructType\RetrieveHallVersionDesign_Response|bool
     */
    public function RetrieveHallVersionDesign(\patest\StructType\RetrieveHallVersionDesign_Request $iTicketingFacade_RetrieveHallVersionDesign_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveHallVersionDesign($iTicketingFacade_RetrieveHallVersionDesign_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\RetrieveAccountResponse|\patest\StructType\RetrieveClientPurchasesResponse|\patest\StructType\RetrieveCustomerResponse|\patest\StructType\RetrieveHallVersionDesign_Response|\patest\StructType\RetrieveSalesItemsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
