<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Resolve ServiceType
 * @subpackage Services
 */
class Resolve extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\ArrayType\ArrayOfKeyValueOfstringstring $context, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named
     * ResolveClientNameBySalutationFormat
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ResolveClientNameBySalutationFormatRequest $iCrmFacade_ResolveClientNameBySalutationFormat_RequestMsg
     * @return \patest\StructType\ResolveClientNameBySalutationFormatResponse|bool
     */
    public function ResolveClientNameBySalutationFormat(\patest\StructType\ResolveClientNameBySalutationFormatRequest $iCrmFacade_ResolveClientNameBySalutationFormat_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ResolveClientNameBySalutationFormat($iCrmFacade_ResolveClientNameBySalutationFormat_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ResolveCouponByNumber
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ResolveCouponByNumber_Request $iGiftVoucherFacade_ResolveCouponByNumber_RequestMsg
     * @return \patest\StructType\ResolveCouponByNumber_Response|bool
     */
    public function ResolveCouponByNumber(\patest\StructType\ResolveCouponByNumber_Request $iGiftVoucherFacade_ResolveCouponByNumber_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ResolveCouponByNumber($iGiftVoucherFacade_ResolveCouponByNumber_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ResolvePresaleByCode
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ResolvePresaleByCode_Request $iTicketingFacade_ResolvePresaleByCode_RequestMsg
     * @return \patest\StructType\ResolvePresaleByCode_Response|bool
     */
    public function ResolvePresaleByCode(\patest\StructType\ResolvePresaleByCode_Request $iTicketingFacade_ResolvePresaleByCode_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ResolvePresaleByCode($iTicketingFacade_ResolvePresaleByCode_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\ResolveClientNameBySalutationFormatResponse|\patest\StructType\ResolveCouponByNumber_Response|\patest\StructType\ResolvePresaleByCode_Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
