<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\Context $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\StructType\Context $context, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Create
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\EntitiesCreateOrUpdateRequest $iSoapEntityManagementFacade_Create_RequestMsg
     * @return \patest\StructType\EntitiesCreateOrUpdateResponse|bool
     */
    public function Create(\patest\StructType\EntitiesCreateOrUpdateRequest $iSoapEntityManagementFacade_Create_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->Create($iSoapEntityManagementFacade_Create_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateBarcodeForProduct
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CreateBarcodeForProduct_Request $iAccessControlFacade_CreateBarcodeForProduct_RequestMsg
     * @return \patest\StructType\CreateBarcodeForProduct_Response|bool
     */
    public function CreateBarcodeForProduct(\patest\StructType\CreateBarcodeForProduct_Request $iAccessControlFacade_CreateBarcodeForProduct_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateBarcodeForProduct($iAccessControlFacade_CreateBarcodeForProduct_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateExternalImportedBarcode
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CreateExternalImportedBarcode_Request $iAccessControlFacade_CreateExternalImportedBarcode_RequestMsg
     * @return \patest\StructType\CreateExternalImportedBarcode_Response|bool
     */
    public function CreateExternalImportedBarcode(\patest\StructType\CreateExternalImportedBarcode_Request $iAccessControlFacade_CreateExternalImportedBarcode_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateExternalImportedBarcode($iAccessControlFacade_CreateExternalImportedBarcode_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateVisit
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CreateVisitRequest $iBizResourceFacade_CreateVisit_RequestMsg
     * @return \patest\StructType\CreateVisitResponse|bool
     */
    public function CreateVisit(\patest\StructType\CreateVisitRequest $iBizResourceFacade_CreateVisit_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateVisit($iBizResourceFacade_CreateVisit_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateCustomer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CreateCustomerRequest $iCrmFacade_CreateCustomer_RequestMsg
     * @return \patest\StructType\CreateCustomerResponse|bool
     */
    public function CreateCustomer(\patest\StructType\CreateCustomerRequest $iCrmFacade_CreateCustomer_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateCustomer($iCrmFacade_CreateCustomer_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateAccount
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CreateAccountRequest $iCrmFacade_CreateAccount_RequestMsg
     * @return \patest\StructType\CreateAccountResponse|bool
     */
    public function CreateAccount(\patest\StructType\CreateAccountRequest $iCrmFacade_CreateAccount_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateAccount($iCrmFacade_CreateAccount_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePaymentTokenWithoutPayment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CreatePaymentTokenWithoutPaymentRequest $iPaymentFacade_CreatePaymentTokenWithoutPayment_RequestMsg
     * @return \patest\StructType\CreatePaymentTokenWithoutPaymentResponse|bool
     */
    public function CreatePaymentTokenWithoutPayment(\patest\StructType\CreatePaymentTokenWithoutPaymentRequest $iPaymentFacade_CreatePaymentTokenWithoutPayment_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CreatePaymentTokenWithoutPayment($iPaymentFacade_CreatePaymentTokenWithoutPayment_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateSession
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CreatePaymentContextRequest $iPaymentFacade_CreateSession_RequestMsg
     * @return \patest\StructType\CreatePaymentContextResponse|bool
     */
    public function CreateSession(\patest\StructType\CreatePaymentContextRequest $iPaymentFacade_CreateSession_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateSession($iPaymentFacade_CreateSession_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePayment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CreatePaymentRequest $iPaymentFacade_CreatePayment_RequestMsg
     * @return \patest\StructType\CreatePaymentResponse|bool
     */
    public function CreatePayment(\patest\StructType\CreatePaymentRequest $iPaymentFacade_CreatePayment_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CreatePayment($iPaymentFacade_CreatePayment_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateNewTransaction
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CreateNewTransaction_Request $iSaleFacade_CreateNewTransaction_RequestMsg
     * @return \patest\StructType\CreateNewTransaction_Response|bool
     */
    public function CreateNewTransaction(\patest\StructType\CreateNewTransaction_Request $iSaleFacade_CreateNewTransaction_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateNewTransaction($iSaleFacade_CreateNewTransaction_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateOrUpdatePriceList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CreateOrUpdatePriceList_Request $iSaleFacade_CreateOrUpdatePriceList_RequestMsg
     * @return \patest\StructType\CreateOrUpdatePriceList_Response|bool
     */
    public function CreateOrUpdatePriceList(\patest\StructType\CreateOrUpdatePriceList_Request $iSaleFacade_CreateOrUpdatePriceList_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateOrUpdatePriceList($iSaleFacade_CreateOrUpdatePriceList_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateDraftInvoices
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CreateDraftInvoices_Request $iSaleFacade_CreateDraftInvoices_RequestMsg
     * @return \patest\StructType\CreateDraftInvoices_Response|bool
     */
    public function CreateDraftInvoices(\patest\StructType\CreateDraftInvoices_Request $iSaleFacade_CreateDraftInvoices_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateDraftInvoices($iSaleFacade_CreateDraftInvoices_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateOnsale
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CreateOnsale_Request $iTicketingFacade_CreateOnsale_RequestMsg
     * @return \patest\StructType\CreateOnsale_Response|bool
     */
    public function CreateOnsale(\patest\StructType\CreateOnsale_Request $iTicketingFacade_CreateOnsale_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateOnsale($iTicketingFacade_CreateOnsale_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePresale
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CreatePresale_Request $iTicketingFacade_CreatePresale_RequestMsg
     * @return \patest\StructType\CreatePresale_Response|bool
     */
    public function CreatePresale(\patest\StructType\CreatePresale_Request $iTicketingFacade_CreatePresale_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CreatePresale($iTicketingFacade_CreatePresale_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePresaleAsync
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CreatePresale_Request $iTicketingFacade_CreatePresaleAsync_RequestMsg
     * @return \patest\StructType\CreatePresaleAsync_Response|bool
     */
    public function CreatePresaleAsync(\patest\StructType\CreatePresale_Request $iTicketingFacade_CreatePresaleAsync_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CreatePresaleAsync($iTicketingFacade_CreatePresaleAsync_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateTicketViewComponent
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\TicketViewComponentCreate_Request $iTicketingFacade_CreateTicketViewComponent_RequestMsg
     * @return \patest\StructType\CreateTicketViewComponent_Response|bool
     */
    public function CreateTicketViewComponent(\patest\StructType\TicketViewComponentCreate_Request $iTicketingFacade_CreateTicketViewComponent_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateTicketViewComponent($iTicketingFacade_CreateTicketViewComponent_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateTicketViewAssociation
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CreateTicketViewAssociation_Request $iTicketingFacade_CreateTicketViewAssociation_RequestMsg
     * @return \patest\StructType\CreateTicketViewAssociation_Response|bool
     */
    public function CreateTicketViewAssociation(\patest\StructType\CreateTicketViewAssociation_Request $iTicketingFacade_CreateTicketViewAssociation_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateTicketViewAssociation($iTicketingFacade_CreateTicketViewAssociation_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\CreateAccountResponse|\patest\StructType\CreateBarcodeForProduct_Response|\patest\StructType\CreateCustomerResponse|\patest\StructType\CreateDraftInvoices_Response|\patest\StructType\CreateExternalImportedBarcode_Response|\patest\StructType\CreateNewTransaction_Response|\patest\StructType\CreateOnsale_Response|\patest\StructType\CreateOrUpdatePriceList_Response|\patest\StructType\CreatePaymentContextResponse|\patest\StructType\CreatePaymentResponse|\patest\StructType\CreatePaymentTokenWithoutPaymentResponse|\patest\StructType\CreatePresaleAsync_Response|\patest\StructType\CreatePresale_Response|\patest\StructType\CreateTicketViewAssociation_Response|\patest\StructType\CreateTicketViewComponent_Response|\patest\StructType\CreateVisitResponse|\patest\StructType\EntitiesCreateOrUpdateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
