<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Check ServiceType
 * @subpackage Services
 */
class Check extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\ArrayType\ArrayOfKeyValueOfstringstring $context, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named CheckClientDuplications
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CheckClientDuplicationsRequest $iCrmFacade_CheckClientDuplications_RequestMsg
     * @return \patest\StructType\CheckClientDuplicationsResponse|bool
     */
    public function CheckClientDuplications(\patest\StructType\CheckClientDuplicationsRequest $iCrmFacade_CheckClientDuplications_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckClientDuplications($iCrmFacade_CheckClientDuplications_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CheckTicketsForHolder
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CheckTicketsForHolderRequest $iTicketingFacade_CheckTicketsForHolder_RequestMsg
     * @return \patest\StructType\CheckTicketsForHolderResponse|bool
     */
    public function CheckTicketsForHolder(\patest\StructType\CheckTicketsForHolderRequest $iTicketingFacade_CheckTicketsForHolder_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckTicketsForHolder($iTicketingFacade_CheckTicketsForHolder_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CheckSGOServicesStatus
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CheckSGOServicesStatusRequest_Request $iTicketingFacade_CheckSGOServicesStatus_RequestMsg
     * @return \patest\StructType\CheckSGOServicesStatusResponse|bool
     */
    public function CheckSGOServicesStatus(\patest\StructType\CheckSGOServicesStatusRequest_Request $iTicketingFacade_CheckSGOServicesStatus_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckSGOServicesStatus($iTicketingFacade_CheckSGOServicesStatus_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CheckAccessCodes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CheckAccessCodes_Request $iTicketingFacade_CheckAccessCodes_RequestMsg
     * @return \patest\StructType\CheckAccessCodes_Response|bool
     */
    public function CheckAccessCodes(\patest\StructType\CheckAccessCodes_Request $iTicketingFacade_CheckAccessCodes_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckAccessCodes($iTicketingFacade_CheckAccessCodes_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CheckPresaleNameDuplication
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\CheckPresaleNameDuplication_Request $iTicketingFacade_CheckPresaleNameDuplication_RequestMsg
     * @return \patest\StructType\CheckPresaleNameDuplication_Response|bool
     */
    public function CheckPresaleNameDuplication(\patest\StructType\CheckPresaleNameDuplication_Request $iTicketingFacade_CheckPresaleNameDuplication_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckPresaleNameDuplication($iTicketingFacade_CheckPresaleNameDuplication_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\CheckAccessCodes_Response|\patest\StructType\CheckClientDuplicationsResponse|\patest\StructType\CheckPresaleNameDuplication_Response|\patest\StructType\CheckSGOServicesStatusResponse|\patest\StructType\CheckTicketsForHolderResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
