<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Change ServiceType
 * @subpackage Services
 */
class Change extends AbstractSoapClientBase
{
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\ArrayType\ArrayOfKeyValueOfstringstring $context, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ChangePassword
     * This method has been renamed because it is defined several times but with
     * different signature
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SroBusinessFlow, Context
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\StructType\SroBusinessFlow, \patest\ArrayType\ArrayOfKeyValueOfstringstring
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ChangePassword_Request $iAuthenticationFacade_ChangePassword_RequestMsg
     * @return \patest\StructType\ChangePassword_Response|bool
     */
    public function ChangePassword(\patest\StructType\ChangePassword_Request $iAuthenticationFacade_ChangePassword_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ChangePassword($iAuthenticationFacade_ChangePassword_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChangePassword
     * This method has been renamed because it is defined several times but with
     * different signature
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\Crm_ChangePassword_Request $iCrmFacade_ChangePassword_RequestMsg
     * @return \patest\StructType\Crm_ChangePassword_Response|bool
     */
    public function ChangePassword_bfa29dc8f8aa3bfbb9f71d920d25c90b(\patest\StructType\Crm_ChangePassword_Request $iCrmFacade_ChangePassword_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ChangePassword($iCrmFacade_ChangePassword_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChangeSubscriptionTicketsPriceType
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ChangeSubscriptionTicketsPriceType_Request $iEsroFacade_ChangeSubscriptionTicketsPriceType_RequestMsg
     * @return \patest\StructType\ChangeSubscriptionTicketsPriceType_Response|bool
     */
    public function ChangeSubscriptionTicketsPriceType(\patest\StructType\ChangeSubscriptionTicketsPriceType_Request $iEsroFacade_ChangeSubscriptionTicketsPriceType_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ChangeSubscriptionTicketsPriceType($iEsroFacade_ChangeSubscriptionTicketsPriceType_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChangeOfOwnership
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ChangeOfOwnershipRequest $iEsroFacade_ChangeOfOwnership_RequestMsg
     * @return \patest\StructType\ChangeOfOwnershipResponse|bool
     */
    public function ChangeOfOwnership(\patest\StructType\ChangeOfOwnershipRequest $iEsroFacade_ChangeOfOwnership_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ChangeOfOwnership($iEsroFacade_ChangeOfOwnership_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ChangeTicketOwner
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\ChangeTicketOwnerRequest $iEsroFacade_ChangeTicketOwner_RequestMsg
     * @return \patest\StructType\ChangeTicketOwnerResponse|bool
     */
    public function ChangeTicketOwner(\patest\StructType\ChangeTicketOwnerRequest $iEsroFacade_ChangeTicketOwner_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->ChangeTicketOwner($iEsroFacade_ChangeTicketOwner_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\ChangeOfOwnershipResponse|\patest\StructType\ChangePassword_Response|\patest\StructType\ChangeSubscriptionTicketsPriceType_Response|\patest\StructType\ChangeTicketOwnerResponse|\patest\StructType\Crm_ChangePassword_Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
