<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for TransactionSnapshotType EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TransactionSnapshotType
 * @subpackage Enumerations
 */
class TransactionSnapshotType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Complete'
     * @return string 'Complete'
     */
    const VALUE_COMPLETE = 'Complete';
    /**
     * Constant for value 'NoBasket'
     * @return string 'NoBasket'
     */
    const VALUE_NO_BASKET = 'NoBasket';
    /**
     * Constant for value 'GroupedBasket'
     * @return string 'GroupedBasket'
     */
    const VALUE_GROUPED_BASKET = 'GroupedBasket';
    /**
     * Constant for value 'GroupedAndCompleteBasket'
     * @return string 'GroupedAndCompleteBasket'
     */
    const VALUE_GROUPED_AND_COMPLETE_BASKET = 'GroupedAndCompleteBasket';
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_COMPLETE
     * @uses self::VALUE_NO_BASKET
     * @uses self::VALUE_GROUPED_BASKET
     * @uses self::VALUE_GROUPED_AND_COMPLETE_BASKET
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_COMPLETE,
            self::VALUE_NO_BASKET,
            self::VALUE_GROUPED_BASKET,
            self::VALUE_GROUPED_AND_COMPLETE_BASKET,
        );
    }
}
