<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for TillCloseOption EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TillCloseOption
 * @subpackage Enumerations
 */
class TillCloseOption extends AbstractStructEnumBase
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'MineOnly'
     * @return string 'MineOnly'
     */
    const VALUE_MINE_ONLY = 'MineOnly';
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_MINE_ONLY
     * @uses self::VALUE_ALL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_MINE_ONLY,
            self::VALUE_ALL,
        );
    }
}
