<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for TicketDistributionStatus EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketDistributionStatus
 * @subpackage Enumerations
 */
class TicketDistributionStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Active'
     * @return string 'Active'
     */
    const VALUE_ACTIVE = 'Active';
    /**
     * Constant for value 'Distributed'
     * @return string 'Distributed'
     */
    const VALUE_DISTRIBUTED = 'Distributed';
    /**
     * Constant for value 'Redistributed'
     * @return string 'Redistributed'
     */
    const VALUE_REDISTRIBUTED = 'Redistributed';
    /**
     * Constant for value 'Reissued'
     * @return string 'Reissued'
     */
    const VALUE_REISSUED = 'Reissued';
    /**
     * Constant for value 'Recalled'
     * @return string 'Recalled'
     */
    const VALUE_RECALLED = 'Recalled';
    /**
     * Return allowed values
     * @uses self::VALUE_ACTIVE
     * @uses self::VALUE_DISTRIBUTED
     * @uses self::VALUE_REDISTRIBUTED
     * @uses self::VALUE_REISSUED
     * @uses self::VALUE_RECALLED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACTIVE,
            self::VALUE_DISTRIBUTED,
            self::VALUE_REDISTRIBUTED,
            self::VALUE_REISSUED,
            self::VALUE_RECALLED,
        );
    }
}
