<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for SubscriptionStatus EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SubscriptionStatus
 * @subpackage Enumerations
 */
class SubscriptionStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Active'
     * @return string 'Active'
     */
    const VALUE_ACTIVE = 'Active';
    /**
     * Constant for value 'Cancelled'
     * @return string 'Cancelled'
     */
    const VALUE_CANCELLED = 'Cancelled';
    /**
     * Constant for value 'Updated'
     * @return string 'Updated'
     */
    const VALUE_UPDATED = 'Updated';
    /**
     * Constant for value 'InWaitingList'
     * @return string 'InWaitingList'
     */
    const VALUE_IN_WAITING_LIST = 'InWaitingList';
    /**
     * Constant for value 'Reserved'
     * @return string 'Reserved'
     */
    const VALUE_RESERVED = 'Reserved';
    /**
     * Constant for value 'Dispatched'
     * @return string 'Dispatched'
     */
    const VALUE_DISPATCHED = 'Dispatched';
    /**
     * Constant for value 'Frozen'
     * @return string 'Frozen'
     */
    const VALUE_FROZEN = 'Frozen';
    /**
     * Return allowed values
     * @uses self::VALUE_ACTIVE
     * @uses self::VALUE_CANCELLED
     * @uses self::VALUE_UPDATED
     * @uses self::VALUE_IN_WAITING_LIST
     * @uses self::VALUE_RESERVED
     * @uses self::VALUE_DISPATCHED
     * @uses self::VALUE_FROZEN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACTIVE,
            self::VALUE_CANCELLED,
            self::VALUE_UPDATED,
            self::VALUE_IN_WAITING_LIST,
            self::VALUE_RESERVED,
            self::VALUE_DISPATCHED,
            self::VALUE_FROZEN,
        );
    }
}
