<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for SeatActivity EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatActivity
 * @subpackage Enumerations
 */
class SeatActivity extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Sold'
     * @return string 'Sold'
     */
    const VALUE_SOLD = 'Sold';
    /**
     * Constant for value 'Reserved'
     * @return string 'Reserved'
     */
    const VALUE_RESERVED = 'Reserved';
    /**
     * Constant for value 'Confirmed'
     * @return string 'Confirmed'
     */
    const VALUE_CONFIRMED = 'Confirmed';
    /**
     * Constant for value 'Returned'
     * @return string 'Returned'
     */
    const VALUE_RETURNED = 'Returned';
    /**
     * Constant for value 'Printed'
     * @return string 'Printed'
     */
    const VALUE_PRINTED = 'Printed';
    /**
     * Constant for value 'Locked'
     * @return string 'Locked'
     */
    const VALUE_LOCKED = 'Locked';
    /**
     * Constant for value 'UnLocked'
     * @return string 'UnLocked'
     */
    const VALUE_UN_LOCKED = 'UnLocked';
    /**
     * Constant for value 'Allocated'
     * @return string 'Allocated'
     */
    const VALUE_ALLOCATED = 'Allocated';
    /**
     * Constant for value 'UnAllocated'
     * @return string 'UnAllocated'
     */
    const VALUE_UN_ALLOCATED = 'UnAllocated';
    /**
     * Constant for value 'ChangePriceLevel'
     * @return string 'ChangePriceLevel'
     */
    const VALUE_CHANGE_PRICE_LEVEL = 'ChangePriceLevel';
    /**
     * Constant for value 'ChangeSeatType'
     * @return string 'ChangeSeatType'
     */
    const VALUE_CHANGE_SEAT_TYPE = 'ChangeSeatType';
    /**
     * Constant for value 'UnPrivateProperty'
     * @return string 'UnPrivateProperty'
     */
    const VALUE_UN_PRIVATE_PROPERTY = 'UnPrivateProperty';
    /**
     * Constant for value 'PrivateProperty'
     * @return string 'PrivateProperty'
     */
    const VALUE_PRIVATE_PROPERTY = 'PrivateProperty';
    /**
     * Constant for value 'TicketNumberAssigned'
     * @return string 'TicketNumberAssigned'
     */
    const VALUE_TICKET_NUMBER_ASSIGNED = 'TicketNumberAssigned';
    /**
     * Constant for value 'SeatAddedToInventory'
     * @return string 'SeatAddedToInventory'
     */
    const VALUE_SEAT_ADDED_TO_INVENTORY = 'SeatAddedToInventory';
    /**
     * Constant for value 'ChangeLiabilityStatus'
     * @return string 'ChangeLiabilityStatus'
     */
    const VALUE_CHANGE_LIABILITY_STATUS = 'ChangeLiabilityStatus';
    /**
     * Constant for value 'ChangeCost'
     * @return string 'ChangeCost'
     */
    const VALUE_CHANGE_COST = 'ChangeCost';
    /**
     * Constant for value 'ChangeInvoiceDate'
     * @return string 'ChangeInvoiceDate'
     */
    const VALUE_CHANGE_INVOICE_DATE = 'ChangeInvoiceDate';
    /**
     * Constant for value 'ChangeIsPaid'
     * @return string 'ChangeIsPaid'
     */
    const VALUE_CHANGE_IS_PAID = 'ChangeIsPaid';
    /**
     * Constant for value 'ChangeInventoryType'
     * @return string 'ChangeInventoryType'
     */
    const VALUE_CHANGE_INVENTORY_TYPE = 'ChangeInventoryType';
    /**
     * Constant for value 'MovedFrom'
     * @return string 'MovedFrom'
     */
    const VALUE_MOVED_FROM = 'MovedFrom';
    /**
     * Constant for value 'MovedTo'
     * @return string 'MovedTo'
     */
    const VALUE_MOVED_TO = 'MovedTo';
    /**
     * Constant for value 'Reprinted'
     * @return string 'Reprinted'
     */
    const VALUE_REPRINTED = 'Reprinted';
    /**
     * Constant for value 'ResaleRequest'
     * @return string 'ResaleRequest'
     */
    const VALUE_RESALE_REQUEST = 'ResaleRequest';
    /**
     * Constant for value 'CancelResaleRequest'
     * @return string 'CancelResaleRequest'
     */
    const VALUE_CANCEL_RESALE_REQUEST = 'CancelResaleRequest';
    /**
     * Constant for value 'ForwardTicket'
     * @return string 'ForwardTicket'
     */
    const VALUE_FORWARD_TICKET = 'ForwardTicket';
    /**
     * Constant for value 'Handover'
     * @return string 'Handover'
     */
    const VALUE_HANDOVER = 'Handover';
    /**
     * Constant for value 'Distributed'
     * @return string 'Distributed'
     */
    const VALUE_DISTRIBUTED = 'Distributed';
    /**
     * Constant for value 'RecalledFromDistribution'
     * @return string 'RecalledFromDistribution'
     */
    const VALUE_RECALLED_FROM_DISTRIBUTION = 'RecalledFromDistribution';
    /**
     * Constant for value 'Redistributed'
     * @return string 'Redistributed'
     */
    const VALUE_REDISTRIBUTED = 'Redistributed';
    /**
     * Constant for value 'Reissued'
     * @return string 'Reissued'
     */
    const VALUE_REISSUED = 'Reissued';
    /**
     * Constant for value 'SeatLevelPrice'
     * @return string 'SeatLevelPrice'
     */
    const VALUE_SEAT_LEVEL_PRICE = 'SeatLevelPrice';
    /**
     * Constant for value 'UnSeatLevelPrice'
     * @return string 'UnSeatLevelPrice'
     */
    const VALUE_UN_SEAT_LEVEL_PRICE = 'UnSeatLevelPrice';
    /**
     * Constant for value 'PendingTransfer'
     * @return string 'PendingTransfer'
     */
    const VALUE_PENDING_TRANSFER = 'PendingTransfer';
    /**
     * Constant for value 'TicketUpdated'
     * @return string 'TicketUpdated'
     */
    const VALUE_TICKET_UPDATED = 'TicketUpdated';
    /**
     * Constant for value 'SeatAdded'
     * @return string 'SeatAdded'
     */
    const VALUE_SEAT_ADDED = 'SeatAdded';
    /**
     * Constant for value 'SeatRemoved'
     * @return string 'SeatRemoved'
     */
    const VALUE_SEAT_REMOVED = 'SeatRemoved';
    /**
     * Constant for value 'Resold'
     * @return string 'Resold'
     */
    const VALUE_RESOLD = 'Resold';
    /**
     * Constant for value 'Transferred'
     * @return string 'Transferred'
     */
    const VALUE_TRANSFERRED = 'Transferred';
    /**
     * Return allowed values
     * @uses self::VALUE_SOLD
     * @uses self::VALUE_RESERVED
     * @uses self::VALUE_CONFIRMED
     * @uses self::VALUE_RETURNED
     * @uses self::VALUE_PRINTED
     * @uses self::VALUE_LOCKED
     * @uses self::VALUE_UN_LOCKED
     * @uses self::VALUE_ALLOCATED
     * @uses self::VALUE_UN_ALLOCATED
     * @uses self::VALUE_CHANGE_PRICE_LEVEL
     * @uses self::VALUE_CHANGE_SEAT_TYPE
     * @uses self::VALUE_UN_PRIVATE_PROPERTY
     * @uses self::VALUE_PRIVATE_PROPERTY
     * @uses self::VALUE_TICKET_NUMBER_ASSIGNED
     * @uses self::VALUE_SEAT_ADDED_TO_INVENTORY
     * @uses self::VALUE_CHANGE_LIABILITY_STATUS
     * @uses self::VALUE_CHANGE_COST
     * @uses self::VALUE_CHANGE_INVOICE_DATE
     * @uses self::VALUE_CHANGE_IS_PAID
     * @uses self::VALUE_CHANGE_INVENTORY_TYPE
     * @uses self::VALUE_MOVED_FROM
     * @uses self::VALUE_MOVED_TO
     * @uses self::VALUE_REPRINTED
     * @uses self::VALUE_RESALE_REQUEST
     * @uses self::VALUE_CANCEL_RESALE_REQUEST
     * @uses self::VALUE_FORWARD_TICKET
     * @uses self::VALUE_HANDOVER
     * @uses self::VALUE_DISTRIBUTED
     * @uses self::VALUE_RECALLED_FROM_DISTRIBUTION
     * @uses self::VALUE_REDISTRIBUTED
     * @uses self::VALUE_REISSUED
     * @uses self::VALUE_SEAT_LEVEL_PRICE
     * @uses self::VALUE_UN_SEAT_LEVEL_PRICE
     * @uses self::VALUE_PENDING_TRANSFER
     * @uses self::VALUE_TICKET_UPDATED
     * @uses self::VALUE_SEAT_ADDED
     * @uses self::VALUE_SEAT_REMOVED
     * @uses self::VALUE_RESOLD
     * @uses self::VALUE_TRANSFERRED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SOLD,
            self::VALUE_RESERVED,
            self::VALUE_CONFIRMED,
            self::VALUE_RETURNED,
            self::VALUE_PRINTED,
            self::VALUE_LOCKED,
            self::VALUE_UN_LOCKED,
            self::VALUE_ALLOCATED,
            self::VALUE_UN_ALLOCATED,
            self::VALUE_CHANGE_PRICE_LEVEL,
            self::VALUE_CHANGE_SEAT_TYPE,
            self::VALUE_UN_PRIVATE_PROPERTY,
            self::VALUE_PRIVATE_PROPERTY,
            self::VALUE_TICKET_NUMBER_ASSIGNED,
            self::VALUE_SEAT_ADDED_TO_INVENTORY,
            self::VALUE_CHANGE_LIABILITY_STATUS,
            self::VALUE_CHANGE_COST,
            self::VALUE_CHANGE_INVOICE_DATE,
            self::VALUE_CHANGE_IS_PAID,
            self::VALUE_CHANGE_INVENTORY_TYPE,
            self::VALUE_MOVED_FROM,
            self::VALUE_MOVED_TO,
            self::VALUE_REPRINTED,
            self::VALUE_RESALE_REQUEST,
            self::VALUE_CANCEL_RESALE_REQUEST,
            self::VALUE_FORWARD_TICKET,
            self::VALUE_HANDOVER,
            self::VALUE_DISTRIBUTED,
            self::VALUE_RECALLED_FROM_DISTRIBUTION,
            self::VALUE_REDISTRIBUTED,
            self::VALUE_REISSUED,
            self::VALUE_SEAT_LEVEL_PRICE,
            self::VALUE_UN_SEAT_LEVEL_PRICE,
            self::VALUE_PENDING_TRANSFER,
            self::VALUE_TICKET_UPDATED,
            self::VALUE_SEAT_ADDED,
            self::VALUE_SEAT_REMOVED,
            self::VALUE_RESOLD,
            self::VALUE_TRANSFERRED,
        );
    }
}
