<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ProductDescriptionLevel EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ProductDescriptionLevel
 * @subpackage Enumerations
 */
class ProductDescriptionLevel extends AbstractStructEnumBase
{
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Constant for value 'ProductDescription'
     * @return string 'ProductDescription'
     */
    const VALUE_PRODUCT_DESCRIPTION = 'ProductDescription';
    /**
     * Constant for value 'PriceAxisDescriptions'
     * @return string 'PriceAxisDescriptions'
     */
    const VALUE_PRICE_AXIS_DESCRIPTIONS = 'PriceAxisDescriptions';
    /**
     * Constant for value 'PriceList'
     * @return string 'PriceList'
     */
    const VALUE_PRICE_LIST = 'PriceList';
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_PRODUCT_DESCRIPTION
     * @uses self::VALUE_PRICE_AXIS_DESCRIPTIONS
     * @uses self::VALUE_PRICE_LIST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_PRODUCT_DESCRIPTION,
            self::VALUE_PRICE_AXIS_DESCRIPTIONS,
            self::VALUE_PRICE_LIST,
        );
    }
}
