<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for PaymentType EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentType
 * @subpackage Enumerations
 */
class PaymentType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'CreditCard'
     * @return string 'CreditCard'
     */
    const VALUE_CREDIT_CARD = 'CreditCard';
    /**
     * Constant for value 'ApplePay'
     * @return string 'ApplePay'
     */
    const VALUE_APPLE_PAY = 'ApplePay';
    /**
     * Constant for value 'GooglePay'
     * @return string 'GooglePay'
     */
    const VALUE_GOOGLE_PAY = 'GooglePay';
    /**
     * Constant for value 'Paypal'
     * @return string 'Paypal'
     */
    const VALUE_PAYPAL = 'Paypal';
    /**
     * Constant for value 'Ach'
     * @return string 'Ach'
     */
    const VALUE_ACH = 'Ach';
    /**
     * Constant for value 'MultiSelect'
     * @return string 'MultiSelect'
     */
    const VALUE_MULTI_SELECT = 'MultiSelect';
    /**
     * Constant for value 'Ideal'
     * @return string 'Ideal'
     */
    const VALUE_IDEAL = 'Ideal';
    /**
     * Constant for value 'GiftCard'
     * @return string 'GiftCard'
     */
    const VALUE_GIFT_CARD = 'GiftCard';
    /**
     * Constant for value 'Bancontact'
     * @return string 'Bancontact'
     */
    const VALUE_BANCONTACT = 'Bancontact';
    /**
     * Return allowed values
     * @uses self::VALUE_CREDIT_CARD
     * @uses self::VALUE_APPLE_PAY
     * @uses self::VALUE_GOOGLE_PAY
     * @uses self::VALUE_PAYPAL
     * @uses self::VALUE_ACH
     * @uses self::VALUE_MULTI_SELECT
     * @uses self::VALUE_IDEAL
     * @uses self::VALUE_GIFT_CARD
     * @uses self::VALUE_BANCONTACT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CREDIT_CARD,
            self::VALUE_APPLE_PAY,
            self::VALUE_GOOGLE_PAY,
            self::VALUE_PAYPAL,
            self::VALUE_ACH,
            self::VALUE_MULTI_SELECT,
            self::VALUE_IDEAL,
            self::VALUE_GIFT_CARD,
            self::VALUE_BANCONTACT,
        );
    }
}
