<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for PaymentIntention EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentIntention
 * @subpackage Enumerations
 */
class PaymentIntention extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Online'
     * @return string 'Online'
     */
    const VALUE_ONLINE = 'Online';
    /**
     * Constant for value 'AccountManager'
     * @return string 'AccountManager'
     */
    const VALUE_ACCOUNT_MANAGER = 'AccountManager';
    /**
     * Constant for value 'PaymentTerminal'
     * @return string 'PaymentTerminal'
     */
    const VALUE_PAYMENT_TERMINAL = 'PaymentTerminal';
    /**
     * Constant for value 'BackOffice'
     * @return string 'BackOffice'
     */
    const VALUE_BACK_OFFICE = 'BackOffice';
    /**
     * Return allowed values
     * @uses self::VALUE_ONLINE
     * @uses self::VALUE_ACCOUNT_MANAGER
     * @uses self::VALUE_PAYMENT_TERMINAL
     * @uses self::VALUE_BACK_OFFICE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ONLINE,
            self::VALUE_ACCOUNT_MANAGER,
            self::VALUE_PAYMENT_TERMINAL,
            self::VALUE_BACK_OFFICE,
        );
    }
}
