<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for InstallmentStatus EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:InstallmentStatus
 * @subpackage Enumerations
 */
class InstallmentStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Pending'
     * @return string 'Pending'
     */
    const VALUE_PENDING = 'Pending';
    /**
     * Constant for value 'Succeeded'
     * @return string 'Succeeded'
     */
    const VALUE_SUCCEEDED = 'Succeeded';
    /**
     * Constant for value 'Canceled'
     * @return string 'Canceled'
     */
    const VALUE_CANCELED = 'Canceled';
    /**
     * Constant for value 'Failed'
     * @return string 'Failed'
     */
    const VALUE_FAILED = 'Failed';
    /**
     * Constant for value 'OnHold'
     * @return string 'OnHold'
     */
    const VALUE_ON_HOLD = 'OnHold';
    /**
     * Return allowed values
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_SUCCEEDED
     * @uses self::VALUE_CANCELED
     * @uses self::VALUE_FAILED
     * @uses self::VALUE_ON_HOLD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PENDING,
            self::VALUE_SUCCEEDED,
            self::VALUE_CANCELED,
            self::VALUE_FAILED,
            self::VALUE_ON_HOLD,
        );
    }
}
