<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for FulfillmentExecutionState EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FulfillmentExecutionState
 * @subpackage Enumerations
 */
class FulfillmentExecutionState extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Ready'
     * @return string 'Ready'
     */
    const VALUE_READY = 'Ready';
    /**
     * Constant for value 'ProcessingFulfillment'
     * @return string 'ProcessingFulfillment'
     */
    const VALUE_PROCESSING_FULFILLMENT = 'ProcessingFulfillment';
    /**
     * Constant for value 'ProcessingReservation'
     * @return string 'ProcessingReservation'
     */
    const VALUE_PROCESSING_RESERVATION = 'ProcessingReservation';
    /**
     * Constant for value 'ProcessingCancelation'
     * @return string 'ProcessingCancelation'
     */
    const VALUE_PROCESSING_CANCELATION = 'ProcessingCancelation';
    /**
     * Constant for value 'Aborted'
     * @return string 'Aborted'
     */
    const VALUE_ABORTED = 'Aborted';
    /**
     * Constant for value 'ProcessingTest'
     * @return string 'ProcessingTest'
     */
    const VALUE_PROCESSING_TEST = 'ProcessingTest';
    /**
     * Constant for value 'TestCompleted'
     * @return string 'TestCompleted'
     */
    const VALUE_TEST_COMPLETED = 'TestCompleted';
    /**
     * Constant for value 'ProcessingPayingUnpaid'
     * @return string 'ProcessingPayingUnpaid'
     */
    const VALUE_PROCESSING_PAYING_UNPAID = 'ProcessingPayingUnpaid';
    /**
     * Return allowed values
     * @uses self::VALUE_READY
     * @uses self::VALUE_PROCESSING_FULFILLMENT
     * @uses self::VALUE_PROCESSING_RESERVATION
     * @uses self::VALUE_PROCESSING_CANCELATION
     * @uses self::VALUE_ABORTED
     * @uses self::VALUE_PROCESSING_TEST
     * @uses self::VALUE_TEST_COMPLETED
     * @uses self::VALUE_PROCESSING_PAYING_UNPAID
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_READY,
            self::VALUE_PROCESSING_FULFILLMENT,
            self::VALUE_PROCESSING_RESERVATION,
            self::VALUE_PROCESSING_CANCELATION,
            self::VALUE_ABORTED,
            self::VALUE_PROCESSING_TEST,
            self::VALUE_TEST_COMPLETED,
            self::VALUE_PROCESSING_PAYING_UNPAID,
        );
    }
}
