<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for FinalMessageStatus EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FinalMessageStatus
 * @subpackage Enumerations
 */
class FinalMessageStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'Queued'
     * @return string 'Queued'
     */
    const VALUE_QUEUED = 'Queued';
    /**
     * Constant for value 'Accepted'
     * @return string 'Accepted'
     */
    const VALUE_ACCEPTED = 'Accepted';
    /**
     * Constant for value 'Scheduled'
     * @return string 'Scheduled'
     */
    const VALUE_SCHEDULED = 'Scheduled';
    /**
     * Constant for value 'Sent'
     * @return string 'Sent'
     */
    const VALUE_SENT = 'Sent';
    /**
     * Constant for value 'Delivered'
     * @return string 'Delivered'
     */
    const VALUE_DELIVERED = 'Delivered';
    /**
     * Constant for value 'Canceled'
     * @return string 'Canceled'
     */
    const VALUE_CANCELED = 'Canceled';
    /**
     * Constant for value 'DeliveryUnknown'
     * @return string 'DeliveryUnknown'
     */
    const VALUE_DELIVERY_UNKNOWN = 'DeliveryUnknown';
    /**
     * Constant for value 'Failed'
     * @return string 'Failed'
     */
    const VALUE_FAILED = 'Failed';
    /**
     * Constant for value 'Undelivered'
     * @return string 'Undelivered'
     */
    const VALUE_UNDELIVERED = 'Undelivered';
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_QUEUED
     * @uses self::VALUE_ACCEPTED
     * @uses self::VALUE_SCHEDULED
     * @uses self::VALUE_SENT
     * @uses self::VALUE_DELIVERED
     * @uses self::VALUE_CANCELED
     * @uses self::VALUE_DELIVERY_UNKNOWN
     * @uses self::VALUE_FAILED
     * @uses self::VALUE_UNDELIVERED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_QUEUED,
            self::VALUE_ACCEPTED,
            self::VALUE_SCHEDULED,
            self::VALUE_SENT,
            self::VALUE_DELIVERED,
            self::VALUE_CANCELED,
            self::VALUE_DELIVERY_UNKNOWN,
            self::VALUE_FAILED,
            self::VALUE_UNDELIVERED,
        );
    }
}
