<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for EntityAccessPermission EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EntityAccessPermission
 * @subpackage Enumerations
 */
class EntityAccessPermission extends AbstractStructEnumBase
{
    /**
     * Constant for value 'View'
     * @return string 'View'
     */
    const VALUE_VIEW = 'View';
    /**
     * Constant for value 'Update'
     * @return string 'Update'
     */
    const VALUE_UPDATE = 'Update';
    /**
     * Constant for value 'Delete'
     * @return string 'Delete'
     */
    const VALUE_DELETE = 'Delete';
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Return allowed values
     * @uses self::VALUE_VIEW
     * @uses self::VALUE_UPDATE
     * @uses self::VALUE_DELETE
     * @uses self::VALUE_ALL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VIEW,
            self::VALUE_UPDATE,
            self::VALUE_DELETE,
            self::VALUE_ALL,
        );
    }
}
