<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for DateEnum EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DateEnum
 * @subpackage Enumerations
 */
class DateEnum extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Today'
     * @return string 'Today'
     */
    const VALUE_TODAY = 'Today';
    /**
     * Constant for value 'Tomorrow'
     * @return string 'Tomorrow'
     */
    const VALUE_TOMORROW = 'Tomorrow';
    /**
     * Constant for value 'Yesterday'
     * @return string 'Yesterday'
     */
    const VALUE_YESTERDAY = 'Yesterday';
    /**
     * Constant for value 'ThisWeek'
     * @return string 'ThisWeek'
     */
    const VALUE_THIS_WEEK = 'ThisWeek';
    /**
     * Constant for value 'ThisMonth'
     * @return string 'ThisMonth'
     */
    const VALUE_THIS_MONTH = 'ThisMonth';
    /**
     * Constant for value 'ThisYear'
     * @return string 'ThisYear'
     */
    const VALUE_THIS_YEAR = 'ThisYear';
    /**
     * Constant for value 'SpecificDate'
     * @return string 'SpecificDate'
     */
    const VALUE_SPECIFIC_DATE = 'SpecificDate';
    /**
     * Constant for value 'SpecificDateRange'
     * @return string 'SpecificDateRange'
     */
    const VALUE_SPECIFIC_DATE_RANGE = 'SpecificDateRange';
    /**
     * Return allowed values
     * @uses self::VALUE_TODAY
     * @uses self::VALUE_TOMORROW
     * @uses self::VALUE_YESTERDAY
     * @uses self::VALUE_THIS_WEEK
     * @uses self::VALUE_THIS_MONTH
     * @uses self::VALUE_THIS_YEAR
     * @uses self::VALUE_SPECIFIC_DATE
     * @uses self::VALUE_SPECIFIC_DATE_RANGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TODAY,
            self::VALUE_TOMORROW,
            self::VALUE_YESTERDAY,
            self::VALUE_THIS_WEEK,
            self::VALUE_THIS_MONTH,
            self::VALUE_THIS_YEAR,
            self::VALUE_SPECIFIC_DATE,
            self::VALUE_SPECIFIC_DATE_RANGE,
        );
    }
}
