<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for BusinessOperationLiaStatus EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BusinessOperationLiaStatus
 * @subpackage Enumerations
 */
class BusinessOperationLiaStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NotProcessed'
     * @return string 'NotProcessed'
     */
    const VALUE_NOT_PROCESSED = 'NotProcessed';
    /**
     * Constant for value 'ProcessedSuccessfully'
     * @return string 'ProcessedSuccessfully'
     */
    const VALUE_PROCESSED_SUCCESSFULLY = 'ProcessedSuccessfully';
    /**
     * Constant for value 'ProcessingError'
     * @return string 'ProcessingError'
     */
    const VALUE_PROCESSING_ERROR = 'ProcessingError';
    /**
     * Constant for value 'Irrelevant'
     * @return string 'Irrelevant'
     */
    const VALUE_IRRELEVANT = 'Irrelevant';
    /**
     * Constant for value 'Obsolete'
     * @return string 'Obsolete'
     */
    const VALUE_OBSOLETE = 'Obsolete';
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_PROCESSED
     * @uses self::VALUE_PROCESSED_SUCCESSFULLY
     * @uses self::VALUE_PROCESSING_ERROR
     * @uses self::VALUE_IRRELEVANT
     * @uses self::VALUE_OBSOLETE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_PROCESSED,
            self::VALUE_PROCESSED_SUCCESSFULLY,
            self::VALUE_PROCESSING_ERROR,
            self::VALUE_IRRELEVANT,
            self::VALUE_OBSOLETE,
        );
    }
}
