<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for BatchEntryProcessStatus EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BatchEntryProcessStatus
 * @subpackage Enumerations
 */
class BatchEntryProcessStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NoProcessed'
     * @return string 'NoProcessed'
     */
    const VALUE_NO_PROCESSED = 'NoProcessed';
    /**
     * Constant for value 'NoProcessedWithFailers'
     * @return string 'NoProcessedWithFailers'
     */
    const VALUE_NO_PROCESSED_WITH_FAILERS = 'NoProcessedWithFailers';
    /**
     * Constant for value 'InProcess'
     * @return string 'InProcess'
     */
    const VALUE_IN_PROCESS = 'InProcess';
    /**
     * Constant for value 'Complete'
     * @return string 'Complete'
     */
    const VALUE_COMPLETE = 'Complete';
    /**
     * Constant for value 'CompleteWithFailers'
     * @return string 'CompleteWithFailers'
     */
    const VALUE_COMPLETE_WITH_FAILERS = 'CompleteWithFailers';
    /**
     * Constant for value 'Failed'
     * @return string 'Failed'
     */
    const VALUE_FAILED = 'Failed';
    /**
     * Return allowed values
     * @uses self::VALUE_NO_PROCESSED
     * @uses self::VALUE_NO_PROCESSED_WITH_FAILERS
     * @uses self::VALUE_IN_PROCESS
     * @uses self::VALUE_COMPLETE
     * @uses self::VALUE_COMPLETE_WITH_FAILERS
     * @uses self::VALUE_FAILED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NO_PROCESSED,
            self::VALUE_NO_PROCESSED_WITH_FAILERS,
            self::VALUE_IN_PROCESS,
            self::VALUE_COMPLETE,
            self::VALUE_COMPLETE_WITH_FAILERS,
            self::VALUE_FAILED,
        );
    }
}
