<?php

namespace patest\EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for AccountTypeKind EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AccountTypeKind
 * @subpackage Enumerations
 */
class AccountTypeKind extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Agent'
     * @return string 'Agent'
     */
    const VALUE_AGENT = 'Agent';
    /**
     * Constant for value 'Supplier'
     * @return string 'Supplier'
     */
    const VALUE_SUPPLIER = 'Supplier';
    /**
     * Constant for value 'Owner'
     * @return string 'Owner'
     */
    const VALUE_OWNER = 'Owner';
    /**
     * Constant for value 'Affiliate'
     * @return string 'Affiliate'
     */
    const VALUE_AFFILIATE = 'Affiliate';
    /**
     * Constant for value 'Portal'
     * @return string 'Portal'
     */
    const VALUE_PORTAL = 'Portal';
    /**
     * Constant for value 'GroupBuyer'
     * @return string 'GroupBuyer'
     */
    const VALUE_GROUP_BUYER = 'GroupBuyer';
    /**
     * Constant for value 'Union'
     * @return string 'Union'
     */
    const VALUE_UNION = 'Union';
    /**
     * Constant for value 'AllowOBO'
     * @return string 'AllowOBO'
     */
    const VALUE_ALLOW_OBO = 'AllowOBO';
    /**
     * Constant for value 'Solicitor'
     * @return string 'Solicitor'
     */
    const VALUE_SOLICITOR = 'Solicitor';
    /**
     * Constant for value 'Promoter'
     * @return string 'Promoter'
     */
    const VALUE_PROMOTER = 'Promoter';
    /**
     * Constant for value 'Organizer'
     * @return string 'Organizer'
     */
    const VALUE_ORGANIZER = 'Organizer';
    /**
     * Constant for value 'Charity'
     * @return string 'Charity'
     */
    const VALUE_CHARITY = 'Charity';
    /**
     * Constant for value 'Guide'
     * @return string 'Guide'
     */
    const VALUE_GUIDE = 'Guide';
    /**
     * Constant for value 'School'
     * @return string 'School'
     */
    const VALUE_SCHOOL = 'School';
    /**
     * Return allowed values
     * @uses self::VALUE_AGENT
     * @uses self::VALUE_SUPPLIER
     * @uses self::VALUE_OWNER
     * @uses self::VALUE_AFFILIATE
     * @uses self::VALUE_PORTAL
     * @uses self::VALUE_GROUP_BUYER
     * @uses self::VALUE_UNION
     * @uses self::VALUE_ALLOW_OBO
     * @uses self::VALUE_SOLICITOR
     * @uses self::VALUE_PROMOTER
     * @uses self::VALUE_ORGANIZER
     * @uses self::VALUE_CHARITY
     * @uses self::VALUE_GUIDE
     * @uses self::VALUE_SCHOOL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AGENT,
            self::VALUE_SUPPLIER,
            self::VALUE_OWNER,
            self::VALUE_AFFILIATE,
            self::VALUE_PORTAL,
            self::VALUE_GROUP_BUYER,
            self::VALUE_UNION,
            self::VALUE_ALLOW_OBO,
            self::VALUE_SOLICITOR,
            self::VALUE_PROMOTER,
            self::VALUE_ORGANIZER,
            self::VALUE_CHARITY,
            self::VALUE_GUIDE,
            self::VALUE_SCHOOL,
        );
    }
}
