<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfdateTime ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfdateTime
 * @subpackage Arrays
 */
class ArrayOfdateTime extends AbstractStructArrayBase
{
    /**
     * The dateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $dateTime;
    /**
     * Constructor method for ArrayOfdateTime
     * @uses ArrayOfdateTime::setDateTime()
     * @param string[] $dateTime
     */
    public function __construct(array $dateTime = array())
    {
        $this
            ->setDateTime($dateTime);
    }
    /**
     * Get dateTime value
     * @return string[]|null
     */
    public function getDateTime()
    {
        return $this->dateTime;
    }
    /**
     * This method is responsible for validating the values passed to the setDateTime method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDateTime method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDateTimeForArrayConstraintsFromSetDateTime(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfdateTimeDateTimeItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfdateTimeDateTimeItem)) {
                $invalidValues[] = is_object($arrayOfdateTimeDateTimeItem) ? get_class($arrayOfdateTimeDateTimeItem) : sprintf('%s(%s)', gettype($arrayOfdateTimeDateTimeItem), var_export($arrayOfdateTimeDateTimeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dateTime property can only contain items of type dateTime, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dateTime value
     * @throws \InvalidArgumentException
     * @param string[] $dateTime
     * @return \patest\ArrayType\ArrayOfdateTime
     */
    public function setDateTime(array $dateTime = array())
    {
        // validation for constraint: array
        if ('' !== ($dateTimeArrayErrorMessage = self::validateDateTimeForArrayConstraintsFromSetDateTime($dateTime))) {
            throw new \InvalidArgumentException($dateTimeArrayErrorMessage, __LINE__);
        }
        $this->dateTime = $dateTime;
        return $this;
    }
    /**
     * Add item to dateTime value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \patest\ArrayType\ArrayOfdateTime
     */
    public function addToDateTime($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The dateTime property can only contain items of type dateTime, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dateTime[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string dateTime
     */
    public function getAttributeName()
    {
        return 'dateTime';
    }
}
