<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTransactionItem ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfTransactionItem
 * @subpackage Arrays
 */
class ArrayOfTransactionItem extends AbstractStructArrayBase
{
    /**
     * The TransactionItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TransactionItem[]
     */
    public $TransactionItem;
    /**
     * Constructor method for ArrayOfTransactionItem
     * @uses ArrayOfTransactionItem::setTransactionItem()
     * @param \patest\StructType\TransactionItem[] $transactionItem
     */
    public function __construct(array $transactionItem = array())
    {
        $this
            ->setTransactionItem($transactionItem);
    }
    /**
     * Get TransactionItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TransactionItem[]|null
     */
    public function getTransactionItem()
    {
        return isset($this->TransactionItem) ? $this->TransactionItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTransactionItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransactionItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransactionItemForArrayConstraintsFromSetTransactionItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTransactionItemTransactionItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfTransactionItemTransactionItemItem instanceof \patest\StructType\TransactionItem) {
                $invalidValues[] = is_object($arrayOfTransactionItemTransactionItemItem) ? get_class($arrayOfTransactionItemTransactionItemItem) : sprintf('%s(%s)', gettype($arrayOfTransactionItemTransactionItemItem), var_export($arrayOfTransactionItemTransactionItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TransactionItem property can only contain items of type \patest\StructType\TransactionItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TransactionItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\TransactionItem[] $transactionItem
     * @return \patest\ArrayType\ArrayOfTransactionItem
     */
    public function setTransactionItem(array $transactionItem = array())
    {
        // validation for constraint: array
        if ('' !== ($transactionItemArrayErrorMessage = self::validateTransactionItemForArrayConstraintsFromSetTransactionItem($transactionItem))) {
            throw new \InvalidArgumentException($transactionItemArrayErrorMessage, __LINE__);
        }
        if (is_null($transactionItem) || (is_array($transactionItem) && empty($transactionItem))) {
            unset($this->TransactionItem);
        } else {
            $this->TransactionItem = $transactionItem;
        }
        return $this;
    }
    /**
     * Add item to TransactionItem value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\TransactionItem $item
     * @return \patest\ArrayType\ArrayOfTransactionItem
     */
    public function addToTransactionItem(\patest\StructType\TransactionItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\TransactionItem) {
            throw new \InvalidArgumentException(sprintf('The TransactionItem property can only contain items of type \patest\StructType\TransactionItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TransactionItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\TransactionItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\TransactionItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\TransactionItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\TransactionItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\TransactionItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TransactionItem
     */
    public function getAttributeName()
    {
        return 'TransactionItem';
    }
}
