<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSubscriptionProductItem ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfSubscriptionProductItem
 * @subpackage Arrays
 */
class ArrayOfSubscriptionProductItem extends AbstractStructArrayBase
{
    /**
     * The SubscriptionProductItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SubscriptionProductItem[]
     */
    public $SubscriptionProductItem;
    /**
     * Constructor method for ArrayOfSubscriptionProductItem
     * @uses ArrayOfSubscriptionProductItem::setSubscriptionProductItem()
     * @param \patest\StructType\SubscriptionProductItem[] $subscriptionProductItem
     */
    public function __construct(array $subscriptionProductItem = array())
    {
        $this
            ->setSubscriptionProductItem($subscriptionProductItem);
    }
    /**
     * Get SubscriptionProductItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SubscriptionProductItem[]|null
     */
    public function getSubscriptionProductItem()
    {
        return isset($this->SubscriptionProductItem) ? $this->SubscriptionProductItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSubscriptionProductItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubscriptionProductItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubscriptionProductItemForArrayConstraintsFromSetSubscriptionProductItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSubscriptionProductItemSubscriptionProductItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfSubscriptionProductItemSubscriptionProductItemItem instanceof \patest\StructType\SubscriptionProductItem) {
                $invalidValues[] = is_object($arrayOfSubscriptionProductItemSubscriptionProductItemItem) ? get_class($arrayOfSubscriptionProductItemSubscriptionProductItemItem) : sprintf('%s(%s)', gettype($arrayOfSubscriptionProductItemSubscriptionProductItemItem), var_export($arrayOfSubscriptionProductItemSubscriptionProductItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubscriptionProductItem property can only contain items of type \patest\StructType\SubscriptionProductItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubscriptionProductItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\SubscriptionProductItem[] $subscriptionProductItem
     * @return \patest\ArrayType\ArrayOfSubscriptionProductItem
     */
    public function setSubscriptionProductItem(array $subscriptionProductItem = array())
    {
        // validation for constraint: array
        if ('' !== ($subscriptionProductItemArrayErrorMessage = self::validateSubscriptionProductItemForArrayConstraintsFromSetSubscriptionProductItem($subscriptionProductItem))) {
            throw new \InvalidArgumentException($subscriptionProductItemArrayErrorMessage, __LINE__);
        }
        if (is_null($subscriptionProductItem) || (is_array($subscriptionProductItem) && empty($subscriptionProductItem))) {
            unset($this->SubscriptionProductItem);
        } else {
            $this->SubscriptionProductItem = $subscriptionProductItem;
        }
        return $this;
    }
    /**
     * Add item to SubscriptionProductItem value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\SubscriptionProductItem $item
     * @return \patest\ArrayType\ArrayOfSubscriptionProductItem
     */
    public function addToSubscriptionProductItem(\patest\StructType\SubscriptionProductItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\SubscriptionProductItem) {
            throw new \InvalidArgumentException(sprintf('The SubscriptionProductItem property can only contain items of type \patest\StructType\SubscriptionProductItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SubscriptionProductItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\SubscriptionProductItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\SubscriptionProductItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\SubscriptionProductItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\SubscriptionProductItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\SubscriptionProductItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SubscriptionProductItem
     */
    public function getAttributeName()
    {
        return 'SubscriptionProductItem';
    }
}
