<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfShowDescription ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfShowDescription
 * @subpackage Arrays
 */
class ArrayOfShowDescription extends AbstractStructArrayBase
{
    /**
     * The ShowDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ShowDescription[]
     */
    public $ShowDescription;
    /**
     * Constructor method for ArrayOfShowDescription
     * @uses ArrayOfShowDescription::setShowDescription()
     * @param \patest\StructType\ShowDescription[] $showDescription
     */
    public function __construct(array $showDescription = array())
    {
        $this
            ->setShowDescription($showDescription);
    }
    /**
     * Get ShowDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ShowDescription[]|null
     */
    public function getShowDescription()
    {
        return isset($this->ShowDescription) ? $this->ShowDescription : null;
    }
    /**
     * This method is responsible for validating the values passed to the setShowDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShowDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShowDescriptionForArrayConstraintsFromSetShowDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfShowDescriptionShowDescriptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfShowDescriptionShowDescriptionItem instanceof \patest\StructType\ShowDescription) {
                $invalidValues[] = is_object($arrayOfShowDescriptionShowDescriptionItem) ? get_class($arrayOfShowDescriptionShowDescriptionItem) : sprintf('%s(%s)', gettype($arrayOfShowDescriptionShowDescriptionItem), var_export($arrayOfShowDescriptionShowDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShowDescription property can only contain items of type \patest\StructType\ShowDescription, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShowDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\ShowDescription[] $showDescription
     * @return \patest\ArrayType\ArrayOfShowDescription
     */
    public function setShowDescription(array $showDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($showDescriptionArrayErrorMessage = self::validateShowDescriptionForArrayConstraintsFromSetShowDescription($showDescription))) {
            throw new \InvalidArgumentException($showDescriptionArrayErrorMessage, __LINE__);
        }
        if (is_null($showDescription) || (is_array($showDescription) && empty($showDescription))) {
            unset($this->ShowDescription);
        } else {
            $this->ShowDescription = $showDescription;
        }
        return $this;
    }
    /**
     * Add item to ShowDescription value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\ShowDescription $item
     * @return \patest\ArrayType\ArrayOfShowDescription
     */
    public function addToShowDescription(\patest\StructType\ShowDescription $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\ShowDescription) {
            throw new \InvalidArgumentException(sprintf('The ShowDescription property can only contain items of type \patest\StructType\ShowDescription, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ShowDescription[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\ShowDescription|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\ShowDescription|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\ShowDescription|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\ShowDescription|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\ShowDescription|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ShowDescription
     */
    public function getAttributeName()
    {
        return 'ShowDescription';
    }
}
