<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfServiceItem ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfServiceItem
 * @subpackage Arrays
 */
class ArrayOfServiceItem extends AbstractStructArrayBase
{
    /**
     * The ServiceItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ServiceItem[]
     */
    public $ServiceItem;
    /**
     * Constructor method for ArrayOfServiceItem
     * @uses ArrayOfServiceItem::setServiceItem()
     * @param \patest\StructType\ServiceItem[] $serviceItem
     */
    public function __construct(array $serviceItem = array())
    {
        $this
            ->setServiceItem($serviceItem);
    }
    /**
     * Get ServiceItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ServiceItem[]|null
     */
    public function getServiceItem()
    {
        return isset($this->ServiceItem) ? $this->ServiceItem : null;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceItemForArrayConstraintsFromSetServiceItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfServiceItemServiceItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfServiceItemServiceItemItem instanceof \patest\StructType\ServiceItem) {
                $invalidValues[] = is_object($arrayOfServiceItemServiceItemItem) ? get_class($arrayOfServiceItemServiceItemItem) : sprintf('%s(%s)', gettype($arrayOfServiceItemServiceItemItem), var_export($arrayOfServiceItemServiceItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceItem property can only contain items of type \patest\StructType\ServiceItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\ServiceItem[] $serviceItem
     * @return \patest\ArrayType\ArrayOfServiceItem
     */
    public function setServiceItem(array $serviceItem = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceItemArrayErrorMessage = self::validateServiceItemForArrayConstraintsFromSetServiceItem($serviceItem))) {
            throw new \InvalidArgumentException($serviceItemArrayErrorMessage, __LINE__);
        }
        if (is_null($serviceItem) || (is_array($serviceItem) && empty($serviceItem))) {
            unset($this->ServiceItem);
        } else {
            $this->ServiceItem = $serviceItem;
        }
        return $this;
    }
    /**
     * Add item to ServiceItem value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\ServiceItem $item
     * @return \patest\ArrayType\ArrayOfServiceItem
     */
    public function addToServiceItem(\patest\StructType\ServiceItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\ServiceItem) {
            throw new \InvalidArgumentException(sprintf('The ServiceItem property can only contain items of type \patest\StructType\ServiceItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\ServiceItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\ServiceItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\ServiceItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\ServiceItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\ServiceItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServiceItem
     */
    public function getAttributeName()
    {
        return 'ServiceItem';
    }
}
