<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSeatPropertyNames ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfSeatPropertyNames
 * @subpackage Arrays
 */
class ArrayOfSeatPropertyNames extends AbstractStructArrayBase
{
    /**
     * The SeatPropertyNames
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $SeatPropertyNames;
    /**
     * Constructor method for ArrayOfSeatPropertyNames
     * @uses ArrayOfSeatPropertyNames::setSeatPropertyNames()
     * @param string[] $seatPropertyNames
     */
    public function __construct(array $seatPropertyNames = array())
    {
        $this
            ->setSeatPropertyNames($seatPropertyNames);
    }
    /**
     * Get SeatPropertyNames value
     * @return string[]|null
     */
    public function getSeatPropertyNames()
    {
        return $this->SeatPropertyNames;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatPropertyNames method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatPropertyNames method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatPropertyNamesForArrayConstraintsFromSetSeatPropertyNames(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSeatPropertyNamesSeatPropertyNamesItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\SeatPropertyNames::valueIsValid($arrayOfSeatPropertyNamesSeatPropertyNamesItem)) {
                $invalidValues[] = is_object($arrayOfSeatPropertyNamesSeatPropertyNamesItem) ? get_class($arrayOfSeatPropertyNamesSeatPropertyNamesItem) : sprintf('%s(%s)', gettype($arrayOfSeatPropertyNamesSeatPropertyNamesItem), var_export($arrayOfSeatPropertyNamesSeatPropertyNamesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatPropertyNames', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\SeatPropertyNames::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatPropertyNames value
     * @uses \patest\EnumType\SeatPropertyNames::valueIsValid()
     * @uses \patest\EnumType\SeatPropertyNames::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $seatPropertyNames
     * @return \patest\ArrayType\ArrayOfSeatPropertyNames
     */
    public function setSeatPropertyNames(array $seatPropertyNames = array())
    {
        // validation for constraint: array
        if ('' !== ($seatPropertyNamesArrayErrorMessage = self::validateSeatPropertyNamesForArrayConstraintsFromSetSeatPropertyNames($seatPropertyNames))) {
            throw new \InvalidArgumentException($seatPropertyNamesArrayErrorMessage, __LINE__);
        }
        $this->SeatPropertyNames = $seatPropertyNames;
        return $this;
    }
    /**
     * Add item to SeatPropertyNames value
     * @uses \patest\EnumType\SeatPropertyNames::valueIsValid()
     * @uses \patest\EnumType\SeatPropertyNames::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \patest\ArrayType\ArrayOfSeatPropertyNames
     */
    public function addToSeatPropertyNames($item)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeatPropertyNames::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatPropertyNames', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \patest\EnumType\SeatPropertyNames::getValidValues())), __LINE__);
        }
        $this->SeatPropertyNames[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \patest\EnumType\SeatPropertyNames::valueIsValid()
     * @param string $item
     * @return \patest\ArrayType\ArrayOfSeatPropertyNames
     */
    public function add($item)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeatPropertyNames::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatPropertyNames', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \patest\EnumType\SeatPropertyNames::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SeatPropertyNames
     */
    public function getAttributeName()
    {
        return 'SeatPropertyNames';
    }
}
