<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRuleDescription ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRuleDescription
 * @subpackage Arrays
 */
class ArrayOfRuleDescription extends AbstractStructArrayBase
{
    /**
     * The RuleDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RuleDescription[]
     */
    public $RuleDescription;
    /**
     * Constructor method for ArrayOfRuleDescription
     * @uses ArrayOfRuleDescription::setRuleDescription()
     * @param \patest\StructType\RuleDescription[] $ruleDescription
     */
    public function __construct(array $ruleDescription = array())
    {
        $this
            ->setRuleDescription($ruleDescription);
    }
    /**
     * Get RuleDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RuleDescription[]|null
     */
    public function getRuleDescription()
    {
        return isset($this->RuleDescription) ? $this->RuleDescription : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRuleDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRuleDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRuleDescriptionForArrayConstraintsFromSetRuleDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRuleDescriptionRuleDescriptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfRuleDescriptionRuleDescriptionItem instanceof \patest\StructType\RuleDescription) {
                $invalidValues[] = is_object($arrayOfRuleDescriptionRuleDescriptionItem) ? get_class($arrayOfRuleDescriptionRuleDescriptionItem) : sprintf('%s(%s)', gettype($arrayOfRuleDescriptionRuleDescriptionItem), var_export($arrayOfRuleDescriptionRuleDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RuleDescription property can only contain items of type \patest\StructType\RuleDescription, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RuleDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\RuleDescription[] $ruleDescription
     * @return \patest\ArrayType\ArrayOfRuleDescription
     */
    public function setRuleDescription(array $ruleDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($ruleDescriptionArrayErrorMessage = self::validateRuleDescriptionForArrayConstraintsFromSetRuleDescription($ruleDescription))) {
            throw new \InvalidArgumentException($ruleDescriptionArrayErrorMessage, __LINE__);
        }
        if (is_null($ruleDescription) || (is_array($ruleDescription) && empty($ruleDescription))) {
            unset($this->RuleDescription);
        } else {
            $this->RuleDescription = $ruleDescription;
        }
        return $this;
    }
    /**
     * Add item to RuleDescription value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\RuleDescription $item
     * @return \patest\ArrayType\ArrayOfRuleDescription
     */
    public function addToRuleDescription(\patest\StructType\RuleDescription $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\RuleDescription) {
            throw new \InvalidArgumentException(sprintf('The RuleDescription property can only contain items of type \patest\StructType\RuleDescription, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RuleDescription[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\RuleDescription|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\RuleDescription|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\RuleDescription|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\RuleDescription|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\RuleDescription|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RuleDescription
     */
    public function getAttributeName()
    {
        return 'RuleDescription';
    }
}
