<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfResultRecord ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfResultRecord
 * @subpackage Arrays
 */
class ArrayOfResultRecord extends AbstractStructArrayBase
{
    /**
     * The ResultRecord
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ResultRecord[]
     */
    public $ResultRecord;
    /**
     * Constructor method for ArrayOfResultRecord
     * @uses ArrayOfResultRecord::setResultRecord()
     * @param \patest\StructType\ResultRecord[] $resultRecord
     */
    public function __construct(array $resultRecord = array())
    {
        $this
            ->setResultRecord($resultRecord);
    }
    /**
     * Get ResultRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ResultRecord[]|null
     */
    public function getResultRecord()
    {
        return isset($this->ResultRecord) ? $this->ResultRecord : null;
    }
    /**
     * This method is responsible for validating the values passed to the setResultRecord method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResultRecord method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResultRecordForArrayConstraintsFromSetResultRecord(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfResultRecordResultRecordItem) {
            // validation for constraint: itemType
            if (!$arrayOfResultRecordResultRecordItem instanceof \patest\StructType\ResultRecord) {
                $invalidValues[] = is_object($arrayOfResultRecordResultRecordItem) ? get_class($arrayOfResultRecordResultRecordItem) : sprintf('%s(%s)', gettype($arrayOfResultRecordResultRecordItem), var_export($arrayOfResultRecordResultRecordItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ResultRecord property can only contain items of type \patest\StructType\ResultRecord, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ResultRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\ResultRecord[] $resultRecord
     * @return \patest\ArrayType\ArrayOfResultRecord
     */
    public function setResultRecord(array $resultRecord = array())
    {
        // validation for constraint: array
        if ('' !== ($resultRecordArrayErrorMessage = self::validateResultRecordForArrayConstraintsFromSetResultRecord($resultRecord))) {
            throw new \InvalidArgumentException($resultRecordArrayErrorMessage, __LINE__);
        }
        if (is_null($resultRecord) || (is_array($resultRecord) && empty($resultRecord))) {
            unset($this->ResultRecord);
        } else {
            $this->ResultRecord = $resultRecord;
        }
        return $this;
    }
    /**
     * Add item to ResultRecord value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\ResultRecord $item
     * @return \patest\ArrayType\ArrayOfResultRecord
     */
    public function addToResultRecord(\patest\StructType\ResultRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\ResultRecord) {
            throw new \InvalidArgumentException(sprintf('The ResultRecord property can only contain items of type \patest\StructType\ResultRecord, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ResultRecord[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\ResultRecord|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\ResultRecord|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\ResultRecord|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\ResultRecord|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\ResultRecord|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ResultRecord
     */
    public function getAttributeName()
    {
        return 'ResultRecord';
    }
}
