<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfReservedTicket ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfReservedTicket
 * @subpackage Arrays
 */
class ArrayOfReservedTicket extends AbstractStructArrayBase
{
    /**
     * The ReservedTicket
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ReservedTicket[]
     */
    public $ReservedTicket;
    /**
     * Constructor method for ArrayOfReservedTicket
     * @uses ArrayOfReservedTicket::setReservedTicket()
     * @param \patest\StructType\ReservedTicket[] $reservedTicket
     */
    public function __construct(array $reservedTicket = array())
    {
        $this
            ->setReservedTicket($reservedTicket);
    }
    /**
     * Get ReservedTicket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ReservedTicket[]|null
     */
    public function getReservedTicket()
    {
        return isset($this->ReservedTicket) ? $this->ReservedTicket : null;
    }
    /**
     * This method is responsible for validating the values passed to the setReservedTicket method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReservedTicket method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReservedTicketForArrayConstraintsFromSetReservedTicket(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfReservedTicketReservedTicketItem) {
            // validation for constraint: itemType
            if (!$arrayOfReservedTicketReservedTicketItem instanceof \patest\StructType\ReservedTicket) {
                $invalidValues[] = is_object($arrayOfReservedTicketReservedTicketItem) ? get_class($arrayOfReservedTicketReservedTicketItem) : sprintf('%s(%s)', gettype($arrayOfReservedTicketReservedTicketItem), var_export($arrayOfReservedTicketReservedTicketItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReservedTicket property can only contain items of type \patest\StructType\ReservedTicket, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReservedTicket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\ReservedTicket[] $reservedTicket
     * @return \patest\ArrayType\ArrayOfReservedTicket
     */
    public function setReservedTicket(array $reservedTicket = array())
    {
        // validation for constraint: array
        if ('' !== ($reservedTicketArrayErrorMessage = self::validateReservedTicketForArrayConstraintsFromSetReservedTicket($reservedTicket))) {
            throw new \InvalidArgumentException($reservedTicketArrayErrorMessage, __LINE__);
        }
        if (is_null($reservedTicket) || (is_array($reservedTicket) && empty($reservedTicket))) {
            unset($this->ReservedTicket);
        } else {
            $this->ReservedTicket = $reservedTicket;
        }
        return $this;
    }
    /**
     * Add item to ReservedTicket value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\ReservedTicket $item
     * @return \patest\ArrayType\ArrayOfReservedTicket
     */
    public function addToReservedTicket(\patest\StructType\ReservedTicket $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\ReservedTicket) {
            throw new \InvalidArgumentException(sprintf('The ReservedTicket property can only contain items of type \patest\StructType\ReservedTicket, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReservedTicket[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\ReservedTicket|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\ReservedTicket|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\ReservedTicket|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\ReservedTicket|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\ReservedTicket|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ReservedTicket
     */
    public function getAttributeName()
    {
        return 'ReservedTicket';
    }
}
