<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPaymentType ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPaymentType
 * @subpackage Arrays
 */
class ArrayOfPaymentType extends AbstractStructArrayBase
{
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PaymentType;
    /**
     * Constructor method for ArrayOfPaymentType
     * @uses ArrayOfPaymentType::setPaymentType()
     * @param string[] $paymentType
     */
    public function __construct(array $paymentType = array())
    {
        $this
            ->setPaymentType($paymentType);
    }
    /**
     * Get PaymentType value
     * @return string[]|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentTypeForArrayConstraintsFromSetPaymentType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPaymentTypePaymentTypeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\PaymentType::valueIsValid($arrayOfPaymentTypePaymentTypeItem)) {
                $invalidValues[] = is_object($arrayOfPaymentTypePaymentTypeItem) ? get_class($arrayOfPaymentTypePaymentTypeItem) : sprintf('%s(%s)', gettype($arrayOfPaymentTypePaymentTypeItem), var_export($arrayOfPaymentTypePaymentTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\PaymentType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentType value
     * @uses \patest\EnumType\PaymentType::valueIsValid()
     * @uses \patest\EnumType\PaymentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $paymentType
     * @return \patest\ArrayType\ArrayOfPaymentType
     */
    public function setPaymentType(array $paymentType = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentTypeArrayErrorMessage = self::validatePaymentTypeForArrayConstraintsFromSetPaymentType($paymentType))) {
            throw new \InvalidArgumentException($paymentTypeArrayErrorMessage, __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Add item to PaymentType value
     * @uses \patest\EnumType\PaymentType::valueIsValid()
     * @uses \patest\EnumType\PaymentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \patest\ArrayType\ArrayOfPaymentType
     */
    public function addToPaymentType($item)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \patest\EnumType\PaymentType::getValidValues())), __LINE__);
        }
        $this->PaymentType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \patest\EnumType\PaymentType::valueIsValid()
     * @param string $item
     * @return \patest\ArrayType\ArrayOfPaymentType
     */
    public function add($item)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentType', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \patest\EnumType\PaymentType::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PaymentType
     */
    public function getAttributeName()
    {
        return 'PaymentType';
    }
}
