<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMerchandiseItemsDescription ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfMerchandiseItemsDescription
 * @subpackage Arrays
 */
class ArrayOfMerchandiseItemsDescription extends AbstractStructArrayBase
{
    /**
     * The MerchandiseItemsDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\MerchandiseItemsDescription[]
     */
    public $MerchandiseItemsDescription;
    /**
     * Constructor method for ArrayOfMerchandiseItemsDescription
     * @uses ArrayOfMerchandiseItemsDescription::setMerchandiseItemsDescription()
     * @param \patest\StructType\MerchandiseItemsDescription[] $merchandiseItemsDescription
     */
    public function __construct(array $merchandiseItemsDescription = array())
    {
        $this
            ->setMerchandiseItemsDescription($merchandiseItemsDescription);
    }
    /**
     * Get MerchandiseItemsDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\MerchandiseItemsDescription[]|null
     */
    public function getMerchandiseItemsDescription()
    {
        return isset($this->MerchandiseItemsDescription) ? $this->MerchandiseItemsDescription : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMerchandiseItemsDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMerchandiseItemsDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMerchandiseItemsDescriptionForArrayConstraintsFromSetMerchandiseItemsDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMerchandiseItemsDescriptionMerchandiseItemsDescriptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfMerchandiseItemsDescriptionMerchandiseItemsDescriptionItem instanceof \patest\StructType\MerchandiseItemsDescription) {
                $invalidValues[] = is_object($arrayOfMerchandiseItemsDescriptionMerchandiseItemsDescriptionItem) ? get_class($arrayOfMerchandiseItemsDescriptionMerchandiseItemsDescriptionItem) : sprintf('%s(%s)', gettype($arrayOfMerchandiseItemsDescriptionMerchandiseItemsDescriptionItem), var_export($arrayOfMerchandiseItemsDescriptionMerchandiseItemsDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MerchandiseItemsDescription property can only contain items of type \patest\StructType\MerchandiseItemsDescription, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MerchandiseItemsDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\MerchandiseItemsDescription[] $merchandiseItemsDescription
     * @return \patest\ArrayType\ArrayOfMerchandiseItemsDescription
     */
    public function setMerchandiseItemsDescription(array $merchandiseItemsDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($merchandiseItemsDescriptionArrayErrorMessage = self::validateMerchandiseItemsDescriptionForArrayConstraintsFromSetMerchandiseItemsDescription($merchandiseItemsDescription))) {
            throw new \InvalidArgumentException($merchandiseItemsDescriptionArrayErrorMessage, __LINE__);
        }
        if (is_null($merchandiseItemsDescription) || (is_array($merchandiseItemsDescription) && empty($merchandiseItemsDescription))) {
            unset($this->MerchandiseItemsDescription);
        } else {
            $this->MerchandiseItemsDescription = $merchandiseItemsDescription;
        }
        return $this;
    }
    /**
     * Add item to MerchandiseItemsDescription value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\MerchandiseItemsDescription $item
     * @return \patest\ArrayType\ArrayOfMerchandiseItemsDescription
     */
    public function addToMerchandiseItemsDescription(\patest\StructType\MerchandiseItemsDescription $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\MerchandiseItemsDescription) {
            throw new \InvalidArgumentException(sprintf('The MerchandiseItemsDescription property can only contain items of type \patest\StructType\MerchandiseItemsDescription, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MerchandiseItemsDescription[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\MerchandiseItemsDescription|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\MerchandiseItemsDescription|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\MerchandiseItemsDescription|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\MerchandiseItemsDescription|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\MerchandiseItemsDescription|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MerchandiseItemsDescription
     */
    public function getAttributeName()
    {
        return 'MerchandiseItemsDescription';
    }
}
