<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMerchandiseData ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfMerchandiseData
 * @subpackage Arrays
 */
class ArrayOfMerchandiseData extends AbstractStructArrayBase
{
    /**
     * The MerchandiseData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\MerchandiseData[]
     */
    public $MerchandiseData;
    /**
     * Constructor method for ArrayOfMerchandiseData
     * @uses ArrayOfMerchandiseData::setMerchandiseData()
     * @param \patest\StructType\MerchandiseData[] $merchandiseData
     */
    public function __construct(array $merchandiseData = array())
    {
        $this
            ->setMerchandiseData($merchandiseData);
    }
    /**
     * Get MerchandiseData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\MerchandiseData[]|null
     */
    public function getMerchandiseData()
    {
        return isset($this->MerchandiseData) ? $this->MerchandiseData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMerchandiseData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMerchandiseData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMerchandiseDataForArrayConstraintsFromSetMerchandiseData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMerchandiseDataMerchandiseDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfMerchandiseDataMerchandiseDataItem instanceof \patest\StructType\MerchandiseData) {
                $invalidValues[] = is_object($arrayOfMerchandiseDataMerchandiseDataItem) ? get_class($arrayOfMerchandiseDataMerchandiseDataItem) : sprintf('%s(%s)', gettype($arrayOfMerchandiseDataMerchandiseDataItem), var_export($arrayOfMerchandiseDataMerchandiseDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MerchandiseData property can only contain items of type \patest\StructType\MerchandiseData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MerchandiseData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\MerchandiseData[] $merchandiseData
     * @return \patest\ArrayType\ArrayOfMerchandiseData
     */
    public function setMerchandiseData(array $merchandiseData = array())
    {
        // validation for constraint: array
        if ('' !== ($merchandiseDataArrayErrorMessage = self::validateMerchandiseDataForArrayConstraintsFromSetMerchandiseData($merchandiseData))) {
            throw new \InvalidArgumentException($merchandiseDataArrayErrorMessage, __LINE__);
        }
        if (is_null($merchandiseData) || (is_array($merchandiseData) && empty($merchandiseData))) {
            unset($this->MerchandiseData);
        } else {
            $this->MerchandiseData = $merchandiseData;
        }
        return $this;
    }
    /**
     * Add item to MerchandiseData value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\MerchandiseData $item
     * @return \patest\ArrayType\ArrayOfMerchandiseData
     */
    public function addToMerchandiseData(\patest\StructType\MerchandiseData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\MerchandiseData) {
            throw new \InvalidArgumentException(sprintf('The MerchandiseData property can only contain items of type \patest\StructType\MerchandiseData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MerchandiseData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\MerchandiseData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\MerchandiseData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\MerchandiseData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\MerchandiseData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\MerchandiseData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MerchandiseData
     */
    public function getAttributeName()
    {
        return 'MerchandiseData';
    }
}
