<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfItemIdentity ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfItemIdentity
 * @subpackage Arrays
 */
class ArrayOfItemIdentity extends AbstractStructArrayBase
{
    /**
     * The ItemIdentity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ItemIdentity[]
     */
    public $ItemIdentity;
    /**
     * Constructor method for ArrayOfItemIdentity
     * @uses ArrayOfItemIdentity::setItemIdentity()
     * @param \patest\StructType\ItemIdentity[] $itemIdentity
     */
    public function __construct(array $itemIdentity = array())
    {
        $this
            ->setItemIdentity($itemIdentity);
    }
    /**
     * Get ItemIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ItemIdentity[]|null
     */
    public function getItemIdentity()
    {
        return isset($this->ItemIdentity) ? $this->ItemIdentity : null;
    }
    /**
     * This method is responsible for validating the values passed to the setItemIdentity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemIdentity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemIdentityForArrayConstraintsFromSetItemIdentity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfItemIdentityItemIdentityItem) {
            // validation for constraint: itemType
            if (!$arrayOfItemIdentityItemIdentityItem instanceof \patest\StructType\ItemIdentity) {
                $invalidValues[] = is_object($arrayOfItemIdentityItemIdentityItem) ? get_class($arrayOfItemIdentityItemIdentityItem) : sprintf('%s(%s)', gettype($arrayOfItemIdentityItemIdentityItem), var_export($arrayOfItemIdentityItemIdentityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemIdentity property can only contain items of type \patest\StructType\ItemIdentity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\ItemIdentity[] $itemIdentity
     * @return \patest\ArrayType\ArrayOfItemIdentity
     */
    public function setItemIdentity(array $itemIdentity = array())
    {
        // validation for constraint: array
        if ('' !== ($itemIdentityArrayErrorMessage = self::validateItemIdentityForArrayConstraintsFromSetItemIdentity($itemIdentity))) {
            throw new \InvalidArgumentException($itemIdentityArrayErrorMessage, __LINE__);
        }
        if (is_null($itemIdentity) || (is_array($itemIdentity) && empty($itemIdentity))) {
            unset($this->ItemIdentity);
        } else {
            $this->ItemIdentity = $itemIdentity;
        }
        return $this;
    }
    /**
     * Add item to ItemIdentity value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\ItemIdentity $item
     * @return \patest\ArrayType\ArrayOfItemIdentity
     */
    public function addToItemIdentity(\patest\StructType\ItemIdentity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\ItemIdentity) {
            throw new \InvalidArgumentException(sprintf('The ItemIdentity property can only contain items of type \patest\StructType\ItemIdentity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemIdentity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\ItemIdentity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\ItemIdentity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\ItemIdentity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\ItemIdentity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\ItemIdentity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ItemIdentity
     */
    public function getAttributeName()
    {
        return 'ItemIdentity';
    }
}
