<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfImageMedia ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfImageMedia
 * @subpackage Arrays
 */
class ArrayOfImageMedia extends AbstractStructArrayBase
{
    /**
     * The ImageMedia
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ImageMedia[]
     */
    public $ImageMedia;
    /**
     * Constructor method for ArrayOfImageMedia
     * @uses ArrayOfImageMedia::setImageMedia()
     * @param \patest\StructType\ImageMedia[] $imageMedia
     */
    public function __construct(array $imageMedia = array())
    {
        $this
            ->setImageMedia($imageMedia);
    }
    /**
     * Get ImageMedia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ImageMedia[]|null
     */
    public function getImageMedia()
    {
        return isset($this->ImageMedia) ? $this->ImageMedia : null;
    }
    /**
     * This method is responsible for validating the values passed to the setImageMedia method
     * This method is willingly generated in order to preserve the one-line inline validation within the setImageMedia method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateImageMediaForArrayConstraintsFromSetImageMedia(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfImageMediaImageMediaItem) {
            // validation for constraint: itemType
            if (!$arrayOfImageMediaImageMediaItem instanceof \patest\StructType\ImageMedia) {
                $invalidValues[] = is_object($arrayOfImageMediaImageMediaItem) ? get_class($arrayOfImageMediaImageMediaItem) : sprintf('%s(%s)', gettype($arrayOfImageMediaImageMediaItem), var_export($arrayOfImageMediaImageMediaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ImageMedia property can only contain items of type \patest\StructType\ImageMedia, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ImageMedia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\ImageMedia[] $imageMedia
     * @return \patest\ArrayType\ArrayOfImageMedia
     */
    public function setImageMedia(array $imageMedia = array())
    {
        // validation for constraint: array
        if ('' !== ($imageMediaArrayErrorMessage = self::validateImageMediaForArrayConstraintsFromSetImageMedia($imageMedia))) {
            throw new \InvalidArgumentException($imageMediaArrayErrorMessage, __LINE__);
        }
        if (is_null($imageMedia) || (is_array($imageMedia) && empty($imageMedia))) {
            unset($this->ImageMedia);
        } else {
            $this->ImageMedia = $imageMedia;
        }
        return $this;
    }
    /**
     * Add item to ImageMedia value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\ImageMedia $item
     * @return \patest\ArrayType\ArrayOfImageMedia
     */
    public function addToImageMedia(\patest\StructType\ImageMedia $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\ImageMedia) {
            throw new \InvalidArgumentException(sprintf('The ImageMedia property can only contain items of type \patest\StructType\ImageMedia, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ImageMedia[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\ImageMedia|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\ImageMedia|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\ImageMedia|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\ImageMedia|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\ImageMedia|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ImageMedia
     */
    public function getAttributeName()
    {
        return 'ImageMedia';
    }
}
