<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEventDescription ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfEventDescription
 * @subpackage Arrays
 */
class ArrayOfEventDescription extends AbstractStructArrayBase
{
    /**
     * The EventDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventDescription[]
     */
    public $EventDescription;
    /**
     * Constructor method for ArrayOfEventDescription
     * @uses ArrayOfEventDescription::setEventDescription()
     * @param \patest\StructType\EventDescription[] $eventDescription
     */
    public function __construct(array $eventDescription = array())
    {
        $this
            ->setEventDescription($eventDescription);
    }
    /**
     * Get EventDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventDescription[]|null
     */
    public function getEventDescription()
    {
        return isset($this->EventDescription) ? $this->EventDescription : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEventDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEventDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventDescriptionForArrayConstraintsFromSetEventDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfEventDescriptionEventDescriptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfEventDescriptionEventDescriptionItem instanceof \patest\StructType\EventDescription) {
                $invalidValues[] = is_object($arrayOfEventDescriptionEventDescriptionItem) ? get_class($arrayOfEventDescriptionEventDescriptionItem) : sprintf('%s(%s)', gettype($arrayOfEventDescriptionEventDescriptionItem), var_export($arrayOfEventDescriptionEventDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EventDescription property can only contain items of type \patest\StructType\EventDescription, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EventDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\EventDescription[] $eventDescription
     * @return \patest\ArrayType\ArrayOfEventDescription
     */
    public function setEventDescription(array $eventDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($eventDescriptionArrayErrorMessage = self::validateEventDescriptionForArrayConstraintsFromSetEventDescription($eventDescription))) {
            throw new \InvalidArgumentException($eventDescriptionArrayErrorMessage, __LINE__);
        }
        if (is_null($eventDescription) || (is_array($eventDescription) && empty($eventDescription))) {
            unset($this->EventDescription);
        } else {
            $this->EventDescription = $eventDescription;
        }
        return $this;
    }
    /**
     * Add item to EventDescription value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\EventDescription $item
     * @return \patest\ArrayType\ArrayOfEventDescription
     */
    public function addToEventDescription(\patest\StructType\EventDescription $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\EventDescription) {
            throw new \InvalidArgumentException(sprintf('The EventDescription property can only contain items of type \patest\StructType\EventDescription, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EventDescription[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\EventDescription|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\EventDescription|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\EventDescription|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\EventDescription|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\EventDescription|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EventDescription
     */
    public function getAttributeName()
    {
        return 'EventDescription';
    }
}
