<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDataBatchPart ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfDataBatchPart
 * @subpackage Arrays
 */
class ArrayOfDataBatchPart extends AbstractStructArrayBase
{
    /**
     * The DataBatchPart
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\DataBatchPart[]
     */
    public $DataBatchPart;
    /**
     * Constructor method for ArrayOfDataBatchPart
     * @uses ArrayOfDataBatchPart::setDataBatchPart()
     * @param \patest\StructType\DataBatchPart[] $dataBatchPart
     */
    public function __construct(array $dataBatchPart = array())
    {
        $this
            ->setDataBatchPart($dataBatchPart);
    }
    /**
     * Get DataBatchPart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\DataBatchPart[]|null
     */
    public function getDataBatchPart()
    {
        return isset($this->DataBatchPart) ? $this->DataBatchPart : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDataBatchPart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDataBatchPart method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDataBatchPartForArrayConstraintsFromSetDataBatchPart(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDataBatchPartDataBatchPartItem) {
            // validation for constraint: itemType
            if (!$arrayOfDataBatchPartDataBatchPartItem instanceof \patest\StructType\DataBatchPart) {
                $invalidValues[] = is_object($arrayOfDataBatchPartDataBatchPartItem) ? get_class($arrayOfDataBatchPartDataBatchPartItem) : sprintf('%s(%s)', gettype($arrayOfDataBatchPartDataBatchPartItem), var_export($arrayOfDataBatchPartDataBatchPartItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DataBatchPart property can only contain items of type \patest\StructType\DataBatchPart, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DataBatchPart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\DataBatchPart[] $dataBatchPart
     * @return \patest\ArrayType\ArrayOfDataBatchPart
     */
    public function setDataBatchPart(array $dataBatchPart = array())
    {
        // validation for constraint: array
        if ('' !== ($dataBatchPartArrayErrorMessage = self::validateDataBatchPartForArrayConstraintsFromSetDataBatchPart($dataBatchPart))) {
            throw new \InvalidArgumentException($dataBatchPartArrayErrorMessage, __LINE__);
        }
        if (is_null($dataBatchPart) || (is_array($dataBatchPart) && empty($dataBatchPart))) {
            unset($this->DataBatchPart);
        } else {
            $this->DataBatchPart = $dataBatchPart;
        }
        return $this;
    }
    /**
     * Add item to DataBatchPart value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\DataBatchPart $item
     * @return \patest\ArrayType\ArrayOfDataBatchPart
     */
    public function addToDataBatchPart(\patest\StructType\DataBatchPart $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\DataBatchPart) {
            throw new \InvalidArgumentException(sprintf('The DataBatchPart property can only contain items of type \patest\StructType\DataBatchPart, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DataBatchPart[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\DataBatchPart|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\DataBatchPart|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\DataBatchPart|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\DataBatchPart|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\DataBatchPart|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DataBatchPart
     */
    public function getAttributeName()
    {
        return 'DataBatchPart';
    }
}
