<?php

namespace patest\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBasketItemAccessCardData ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfBasketItemAccessCardData
 * @subpackage Arrays
 */
class ArrayOfBasketItemAccessCardData extends AbstractStructArrayBase
{
    /**
     * The BasketItemAccessCardData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\BasketItemAccessCardData[]
     */
    public $BasketItemAccessCardData;
    /**
     * Constructor method for ArrayOfBasketItemAccessCardData
     * @uses ArrayOfBasketItemAccessCardData::setBasketItemAccessCardData()
     * @param \patest\StructType\BasketItemAccessCardData[] $basketItemAccessCardData
     */
    public function __construct(array $basketItemAccessCardData = array())
    {
        $this
            ->setBasketItemAccessCardData($basketItemAccessCardData);
    }
    /**
     * Get BasketItemAccessCardData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\BasketItemAccessCardData[]|null
     */
    public function getBasketItemAccessCardData()
    {
        return isset($this->BasketItemAccessCardData) ? $this->BasketItemAccessCardData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBasketItemAccessCardData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBasketItemAccessCardData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBasketItemAccessCardDataForArrayConstraintsFromSetBasketItemAccessCardData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBasketItemAccessCardDataBasketItemAccessCardDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfBasketItemAccessCardDataBasketItemAccessCardDataItem instanceof \patest\StructType\BasketItemAccessCardData) {
                $invalidValues[] = is_object($arrayOfBasketItemAccessCardDataBasketItemAccessCardDataItem) ? get_class($arrayOfBasketItemAccessCardDataBasketItemAccessCardDataItem) : sprintf('%s(%s)', gettype($arrayOfBasketItemAccessCardDataBasketItemAccessCardDataItem), var_export($arrayOfBasketItemAccessCardDataBasketItemAccessCardDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BasketItemAccessCardData property can only contain items of type \patest\StructType\BasketItemAccessCardData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BasketItemAccessCardData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\BasketItemAccessCardData[] $basketItemAccessCardData
     * @return \patest\ArrayType\ArrayOfBasketItemAccessCardData
     */
    public function setBasketItemAccessCardData(array $basketItemAccessCardData = array())
    {
        // validation for constraint: array
        if ('' !== ($basketItemAccessCardDataArrayErrorMessage = self::validateBasketItemAccessCardDataForArrayConstraintsFromSetBasketItemAccessCardData($basketItemAccessCardData))) {
            throw new \InvalidArgumentException($basketItemAccessCardDataArrayErrorMessage, __LINE__);
        }
        if (is_null($basketItemAccessCardData) || (is_array($basketItemAccessCardData) && empty($basketItemAccessCardData))) {
            unset($this->BasketItemAccessCardData);
        } else {
            $this->BasketItemAccessCardData = $basketItemAccessCardData;
        }
        return $this;
    }
    /**
     * Add item to BasketItemAccessCardData value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\BasketItemAccessCardData $item
     * @return \patest\ArrayType\ArrayOfBasketItemAccessCardData
     */
    public function addToBasketItemAccessCardData(\patest\StructType\BasketItemAccessCardData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\BasketItemAccessCardData) {
            throw new \InvalidArgumentException(sprintf('The BasketItemAccessCardData property can only contain items of type \patest\StructType\BasketItemAccessCardData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BasketItemAccessCardData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \patest\StructType\BasketItemAccessCardData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \patest\StructType\BasketItemAccessCardData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \patest\StructType\BasketItemAccessCardData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \patest\StructType\BasketItemAccessCardData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \patest\StructType\BasketItemAccessCardData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BasketItemAccessCardData
     */
    public function getAttributeName()
    {
        return 'BasketItemAccessCardData';
    }
}
