<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \patest\ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \patest\ServiceType\Get($options);
$get->setSoapHeaderContext(new \patest\StructType\Context());
$get->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for GetAvailableData operation/method
 */
if ($get->GetAvailableData(new \patest\StructType\GetAvailableDataRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRuleSystemDescription operation/method
 */
if ($get->GetRuleSystemDescription(new \patest\StructType\GetRuleSystemDescriptionRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetListOfLogFiles operation/method
 */
if ($get->GetListOfLogFiles(new \patest\StructType\GetListOfLogFilesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUrlForLogFile operation/method
 */
if ($get->GetUrlForLogFile(new \patest\StructType\GetUrlForLogFileRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEntityManagementQueryTokenContext operation/method
 */
if ($get->GetEntityManagementQueryTokenContext(new \patest\StructType\GetEntityManagementQueryTokenContextRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUpdatedEntities operation/method
 */
if ($get->GetUpdatedEntities(new \patest\StructType\GetUpdatedEntitiesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDeletedEntities operation/method
 */
if ($get->GetDeletedEntities(new \patest\StructType\GetDeletedEntitiesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCrmIdForCardSwipe operation/method
 */
if ($get->GetCrmIdForCardSwipe(new \patest\StructType\GetCrmIdForCardSwipe_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBarcodeEntities operation/method
 */
if ($get->GetBarcodeEntities(new \patest\StructType\GetBarcodeEntities_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTransactionAccessControlData operation/method
 */
if ($get->GetTransactionAccessControlData(new \patest\StructType\GetTransactionAccessControlDataRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAccessControlSystems operation/method
 */
if ($get->GetAccessControlSystems(new \patest\StructType\GetAccessControlSystemsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBarcodeChanges operation/method
 */
if ($get->GetBarcodeChanges(new \patest\StructType\GetBarcodeChangesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTicketsScanningStatus operation/method
 */
if ($get->GetTicketsScanningStatus(new \patest\StructType\GetTicketsScanningStatus_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAccessInfoForTickets operation/method
 */
if ($get->GetAccessInfoForTickets(new \patest\StructType\GetAccessInfoForTickets_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPasswordValidityParameters operation/method
 */
if ($get->GetPasswordValidityParameters(new \patest\StructType\GetPasswordValidityParameters_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetGuidanceDescription operation/method
 */
if ($get->GetGuidanceDescription(new \patest\StructType\GetGuidanceDescriptionRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCurrentClient operation/method
 */
if ($get->GetCurrentClient(new \patest\StructType\GetCurrentClient_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailableSolicitors operation/method
 */
if ($get->GetAvailableSolicitors(new \patest\StructType\GetAvailableSolicitorsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailableSalesRepresentatives operation/method
 */
if ($get->GetAvailableSalesRepresentatives(new \patest\StructType\GetAvailableSalesRepresentativesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailableServiceRepresentatives operation/method
 */
if ($get->GetAvailableServiceRepresentatives(new \patest\StructType\GetAvailableServiceRepresentativesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailableDataProtectionQuestions operation/method
 */
if ($get->GetAvailableDataProtectionQuestions(new \patest\StructType\GetAvailableDataProtectionQuestionsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSgoLinkageInfo operation/method
 */
if ($get->GetSgoLinkageInfo(new \patest\StructType\SgoLinkageInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSGAccountContext operation/method
 */
if ($get->GetSGAccountContext(new \patest\StructType\SGAccountContextRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailableDeliveries operation/method
 */
if ($get->GetAvailableDeliveries(new \patest\StructType\GetAvailableDeliveries_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSoftCreditDefaultsForClient operation/method
 */
if ($get->GetSoftCreditDefaultsForClient(new \patest\StructType\GetSoftCreditDefaultsForClient_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMatchingGiftsReservations operation/method
 */
if ($get->GetMatchingGiftsReservations(new \patest\StructType\GetMatchingGiftsReservations_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetClientWelcomeInfo operation/method
 */
if ($get->GetClientWelcomeInfo(new \patest\StructType\GetClientWelcomeInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllBundleElementsAvailableProducts operation/method
 */
if ($get->GetAllBundleElementsAvailableProducts(new \patest\StructType\GetAllBundleElementsAvailableProductsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBundleElementAvailableProducts operation/method
 */
if ($get->GetBundleElementAvailableProducts(new \patest\StructType\GetBundleElementAvailableProductsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetExtraPromptElementsAvailableProducts operation/method
 */
if ($get->GetExtraPromptElementsAvailableProducts(new \patest\StructType\GetExtraPromptElementAvailablProductsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetExtendedTicketInfo operation/method
 */
if ($get->GetExtendedTicketInfo(new \patest\StructType\GetExtendedTicketInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetClientEvents operation/method
 */
if ($get->GetClientEvents(new \patest\StructType\GetClientEventsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetClientEventTickets operation/method
 */
if ($get->GetClientEventTickets(new \patest\StructType\GetClientEventTicketsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTicketsToManage operation/method
 */
if ($get->GetTicketsToManage(new \patest\StructType\GetTicketsToManageRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRelatedClients operation/method
 */
if ($get->GetRelatedClients(new \patest\StructType\GetRelatedClientsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLinkedClients operation/method
 */
if ($get->GetLinkedClients(new \patest\StructType\GetLinkedClientsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCaptionsByKeys operation/method
 */
if ($get->GetCaptionsByKeys(new \patest\StructType\GetCaptionsByKeysRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCardLoadingDescription operation/method
 */
if ($get->GetCardLoadingDescription(new \patest\StructType\GetCardLoadingDescriptionRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetGiftVoucherDescription operation/method
 */
if ($get->GetGiftVoucherDescription(new \patest\StructType\GetGiftVoucherDescription_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMembershipDefinitionDescription operation/method
 */
if ($get->GetMembershipDefinitionDescription(new \patest\StructType\GetMembershipDefinitionDescription_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSchemeDescription operation/method
 */
if ($get->GetSchemeDescription(new \patest\StructType\GetSchemeDescription_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMerchandiseDescription operation/method
 */
if ($get->GetMerchandiseDescription(new \patest\StructType\GetMerchandiseDescription_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailableMerchandiseItemTypes operation/method
 */
if ($get->GetAvailableMerchandiseItemTypes(new \patest\StructType\GetAvailableMerchandiseItemTypes_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMerchandiseItemsPrices operation/method
 */
if ($get->GetMerchandiseItemsPrices(new \patest\StructType\GetMerchandiseItemsPrices_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailableProducts operation/method
 */
if ($get->GetAvailableProducts(new \patest\StructType\GetAvailableProducts_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProductDescription operation/method
 */
if ($get->GetProductDescription(new \patest\StructType\GetProductDescription_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTaggedProducts operation/method
 */
if ($get->GetTaggedProducts(new \patest\StructType\GetTaggedProductsRequest_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCategories operation/method
 */
if ($get->GetCategories(new \patest\StructType\GetCategories_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProductsAttributesTypes operation/method
 */
if ($get->GetProductsAttributesTypes(new \patest\StructType\GetProductsAttributesTypes_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetClassNodes operation/method
 */
if ($get->GetClassNodes(new \patest\StructType\GetClassNodesRequest_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetClassContent operation/method
 */
if ($get->GetClassContent(new \patest\StructType\GetClassContentRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailablePaymentMethods operation/method
 */
if ($get->GetAvailablePaymentMethods(new \patest\StructType\GetAvailablePaymentMethods_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomerCreditCategories operation/method
 */
if ($get->GetCustomerCreditCategories(new \patest\StructType\GetCustomerCreditCategories_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetClientBalance operation/method
 */
if ($get->GetClientBalance(new \patest\StructType\GetClientBalance_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailableDirectDebitMandates operation/method
 */
if ($get->GetAvailableDirectDebitMandates(new \patest\StructType\GetAvailableDirectDebitMandates_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDirectDebitRecordsToSend operation/method
 */
if ($get->GetDirectDebitRecordsToSend(new \patest\StructType\GetDirectDebitRecordsToSend_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDirectDebitRecordsBatch operation/method
 */
if ($get->GetDirectDebitRecordsBatch(new \patest\StructType\GetDirectDebitRecordsBatch_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailableDeposits operation/method
 */
if ($get->GetAvailableDeposits(new \patest\StructType\GetAvailableDepositsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPaymentPlanDefaults operation/method
 */
if ($get->GetPaymentPlanDefaults(new \patest\StructType\GetPaymentPlanDefaults_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUppConfiguration operation/method
 */
if ($get->GetUppConfiguration(new \patest\StructType\GetUppConfigurationRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailablePrintOptionsForBasketSale operation/method
 */
if ($get->GetAvailablePrintOptionsForBasketSale(new \patest\StructType\GetAvailablePrintOptionsForBasketSale_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailablePrintOptionsForBasketSalesBatch operation/method
 */
if ($get->GetAvailablePrintOptionsForBasketSalesBatch(new \patest\StructType\GetAvailablePrintOptionsForBasketSalesBatch_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailablePrintOptionsForFollowUpBasketPrint operation/method
 */
if ($get->GetAvailablePrintOptionsForFollowUpBasketPrint(new \patest\StructType\GetAvailablePrintOptionsForFollowUpBasketPrint_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDocumentDesignerData operation/method
 */
if ($get->GetDocumentDesignerData(new \patest\StructType\GetDocumentDesignerData_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMergedXmlDocumentsAsXml operation/method
 */
if ($get->GetMergedXmlDocumentsAsXml(new \patest\StructType\GetMergedXmlDocumentsAsXmlRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTransactionPrintedPdfDocuments operation/method
 */
if ($get->GetTransactionPrintedPdfDocuments(new \patest\StructType\GetTransactionPrintedPdfDocumentsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTransactionPrintingMethods operation/method
 */
if ($get->GetTransactionPrintingMethods(new \patest\StructType\GetTransactionPrintingMethodsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProductDescription_8c365580c170dab72fd67248a8d54227
 * operation/method
 */
if ($get->GetProductDescription_8c365580c170dab72fd67248a8d54227(new \patest\StructType\GetProductDescriptionRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailableTills operation/method
 */
if ($get->GetAvailableTills(new \patest\StructType\GetAvailableTills_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOpenShifts operation/method
 */
if ($get->GetOpenShifts(new \patest\StructType\GetOpenShifts_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPrompts operation/method
 */
if ($get->GetPrompts(new \patest\StructType\GetPrompts_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBundleDescription operation/method
 */
if ($get->GetBundleDescription(new \patest\StructType\GetBundleDescriptionRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBundleAvailableDates operation/method
 */
if ($get->GetBundleAvailableDates(new \patest\StructType\GetBundleAvailableDatesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEventsPaidForSubscriptions operation/method
 */
if ($get->GetEventsPaidForSubscriptions(new \patest\StructType\GetEventsPaidForSubscriptionsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBundleElementAvailableDates operation/method
 */
if ($get->GetBundleElementAvailableDates(new \patest\StructType\GetBundleElementAvailableDatesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDefaultBundleContent operation/method
 */
if ($get->GetDefaultBundleContent(new \patest\StructType\GetDefaultBundleContentRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCurrentShift operation/method
 */
if ($get->GetCurrentShift(new \patest\StructType\GetCurrentShiftRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetClientLiabilities operation/method
 */
if ($get->GetClientLiabilities(new \patest\StructType\GetClientLiabilities_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProductsMaxTransactionCommission operation/method
 */
if ($get->GetProductsMaxTransactionCommission(new \patest\StructType\GetProductsMaxTransactionCommission_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetActionInstances operation/method
 */
if ($get->GetActionInstances(new \patest\StructType\GetActionInstances_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetActionInstancesAsObject operation/method
 */
if ($get->GetActionInstancesAsObject(new \patest\StructType\GetActionInstancesAsObject_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSalePoints operation/method
 */
if ($get->GetSalePoints(new \patest\StructType\GetSalePoints_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetContextSalePointConfiguration operation/method
 */
if ($get->GetContextSalePointConfiguration(new \patest\StructType\GetContextSalePointConfigurationRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserApplicationPreference operation/method
 */
if ($get->GetUserApplicationPreference(new \patest\StructType\GetUserApplicationPreferenceRequest_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSubscriptionDescription operation/method
 */
if ($get->GetSubscriptionDescription(new \patest\StructType\GetSubscriptionDescriptionRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSeriesPricing operation/method
 */
if ($get->GetSeriesPricing(new \patest\StructType\SeriesPricingRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetNewSubscriptionPeriods operation/method
 */
if ($get->GetNewSubscriptionPeriods(new \patest\StructType\GetNewSubscriptionPeriodsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailableSeries operation/method
 */
if ($get->GetAvailableSeries(new \patest\StructType\GetAvailableSeries_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCalculatedRelocationsPolicy operation/method
 */
if ($get->GetCalculatedRelocationsPolicy(new \patest\StructType\GetCalculatedRelocationsPolicy_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetClientWaveTime operation/method
 */
if ($get->GetClientWaveTime(new \patest\StructType\GetClientWaveTimeRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTransactionTicketsPrintStatus operation/method
 */
if ($get->GetTransactionTicketsPrintStatus(new \patest\StructType\GetTransactionTicketsPrintStatus_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailableGenres operation/method
 */
if ($get->GetAvailableGenres(new \patest\StructType\GetAvailableGenres_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailableShows operation/method
 */
if ($get->GetAvailableShows(new \patest\StructType\GetAvailableShows_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetShowDescription operation/method
 */
if ($get->GetShowDescription(new \patest\StructType\GetShowDescription_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailableEvents operation/method
 */
if ($get->GetAvailableEvents(new \patest\StructType\GetAvailableEvents_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEventDescription operation/method
 */
if ($get->GetEventDescription(new \patest\StructType\GetEventDescription_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEventSeatStatus operation/method
 */
if ($get->GetEventSeatStatus(new \patest\StructType\GetEventSeatStatus_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSeriesSeatStatus operation/method
 */
if ($get->GetSeriesSeatStatus(new \patest\StructType\GetSeriesSeatStatus_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEventReservations operation/method
 */
if ($get->GetEventReservations(new \patest\StructType\GetEventReservations_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailableRestrictions operation/method
 */
if ($get->GetAvailableRestrictions(new \patest\StructType\GetAvailableRestrictions_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLogicalSeatId operation/method
 */
if ($get->GetLogicalSeatId(new \patest\StructType\GetLogicalSeatId_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetGenresByShowId operation/method
 */
if ($get->GetGenresByShowId(new \patest\StructType\GetGenresByShowId_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSeatHistoryAndInformation operation/method
 */
if ($get->GetSeatHistoryAndInformation(new \patest\StructType\GetSeatHistoryAndInformation_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAreasOfHallVersion operation/method
 */
if ($get->GetAreasOfHallVersion(new \patest\StructType\GetAreasOfHallVersion_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSectorsOfArea operation/method
 */
if ($get->GetSectorsOfArea(new \patest\StructType\GetSectorsOfArea_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSeatToolTipInfo operation/method
 */
if ($get->GetSeatToolTipInfo(new \patest\StructType\GetSeatToolTipInfo_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSetAsideAreaMap operation/method
 */
if ($get->GetSetAsideAreaMap(new \patest\StructType\GetSetAsideAreaMap_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLimitationCounters operation/method
 */
if ($get->GetLimitationCounters(new \patest\StructType\GetLimitationCounters_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEventPricing operation/method
 */
if ($get->GetEventPricing(new \patest\StructType\GetEventPricing_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEventData operation/method
 */
if ($get->GetEventData(new \patest\StructType\GetEventData_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAvailablePriceLevelsForBundle operation/method
 */
if ($get->GetAvailablePriceLevelsForBundle(new \patest\StructType\GetAvailablePriceLevelsForBundle_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTourShowsList operation/method
 */
if ($get->GetTourShowsList(new \patest\StructType\GetTourShowsList_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEventPriceLevelsAndAvailability operation/method
 */
if ($get->GetEventPriceLevelsAndAvailability(new \patest\StructType\GetEventPriceLevelsAndAvailability_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTicketsExtendedInfo operation/method
 */
if ($get->GetTicketsExtendedInfo(new \patest\StructType\GetTicketsExtendedInfo_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEventInfoFromSgo operation/method
 */
if ($get->GetEventInfoFromSgo(new \patest\StructType\GetEventInfoFromSgoRequest_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEventSaleStatusCachingResidue operation/method
 */
if ($get->GetEventSaleStatusCachingResidue(new \patest\StructType\GetEventSaleStatusCachingResidue_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPresaleExtraData operation/method
 */
if ($get->GetPresaleExtraData(new \patest\StructType\GetPresaleExtraData_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPresales operation/method
 */
if ($get->GetPresales(new \patest\StructType\GetPresales_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOnsale operation/method
 */
if ($get->GetOnsale(new \patest\StructType\GetOnsale_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPresaleHistory operation/method
 */
if ($get->GetPresaleHistory(new \patest\StructType\GetPresaleHistory_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDeactivateCodeStatus operation/method
 */
if ($get->GetDeactivateCodeStatus(new \patest\StructType\DeactivateCodeStatus_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPresaleCodeStatus operation/method
 */
if ($get->GetPresaleCodeStatus(new \patest\StructType\PresaleCodeStatus_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomSeatPrices operation/method
 */
if ($get->GetCustomSeatPrices(new \patest\StructType\GetCustomSeatPricesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomSeatPriceForSingleSeat operation/method
 */
if ($get->GetCustomSeatPriceForSingleSeat(new \patest\StructType\GetCustomSeatPriceForSingleSeatRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTicketSchemeEnrollmentsWithoutPaymentMethod operation/method
 */
if ($get->GetTicketSchemeEnrollmentsWithoutPaymentMethod(new \patest\StructType\GetTicketSchemeEnrollmentsWithoutPaymentMethod_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTicketSchemeClientEnrollmentsSummary operation/method
 */
if ($get->GetTicketSchemeClientEnrollmentsSummary(new \patest\StructType\GetTicketSchemeClientEnrollmentsSummary_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPublicEventVisibilityInfo operation/method
 */
if ($get->GetPublicEventVisibilityInfo(new \patest\StructType\GetPublicEventVisibilityInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEventsCrmHasTicketsFor operation/method
 */
if ($get->GetEventsCrmHasTicketsFor(new \patest\StructType\GetEventsCrmHasTicketsFor_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEventTickets operation/method
 */
if ($get->GetEventTickets(new \patest\StructType\GetEventTickets_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEventTicketViewConfiguration operation/method
 */
if ($get->GetEventTicketViewConfiguration(new \patest\StructType\GetEventTicketViewConfiguration_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTicketViewComponentById operation/method
 */
if ($get->GetTicketViewComponentById(new \patest\StructType\TicketViewComponentGet_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTicketViewAssociationsByApplicationObjectIdentifier
 * operation/method
 */
if ($get->GetTicketViewAssociationsByApplicationObjectIdentifier(new \patest\StructType\GetTicketViewAssociationsByApplicationObjectIdentifierRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTicketViewAssociation operation/method
 */
if ($get->GetTicketViewAssociation(new \patest\StructType\GetTicketViewAssociation_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTicketViewConfigurationImagesByImageType operation/method
 */
if ($get->GetTicketViewConfigurationImagesByImageType(new \patest\StructType\GetTicketViewConfigurationImagesByImageTypeRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEligibleEventsForExchangeOut operation/method
 */
if ($get->GetEligibleEventsForExchangeOut(new \patest\StructType\GetEligibleEventsForExchangeOut_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBallotPricing operation/method
 */
if ($get->GetBallotPricing(new \patest\StructType\GetBallotPricingRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBallotApplications operation/method
 */
if ($get->GetBallotApplications(new \patest\StructType\GetBallotApplicationsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEventUpgradeConfig operation/method
 */
if ($get->GetEventUpgradeConfig(new \patest\StructType\GetEventUpgradeConfig_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPriceTypesForTickets operation/method
 */
if ($get->GetPriceTypesForTickets(new \patest\StructType\GetPriceTypesForTicketsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMyTickets operation/method
 */
if ($get->GetMyTickets(new \patest\StructType\GetMyTickets_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTicketViewConfigurationsForEvents operation/method
 */
if ($get->GetTicketViewConfigurationsForEvents(new \patest\StructType\GetTicketViewConfigurationsForEvents_Request()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Confirm ServiceType
 */
$confirm = new \patest\ServiceType\Confirm($options);
$confirm->setSoapHeaderContext(new \patest\StructType\Context());
$confirm->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for ConfirmDataRecieval operation/method
 */
if ($confirm->ConfirmDataRecieval(new \patest\StructType\ConfirmDataReceivedRequest()) !== false) {
    print_r($confirm->getResult());
} else {
    print_r($confirm->getLastError());
}
/**
 * Sample call for ConfirmBasketItems operation/method
 */
if ($confirm->ConfirmBasketItems(new \patest\StructType\ConfirmBasketItems_Request()) !== false) {
    print_r($confirm->getResult());
} else {
    print_r($confirm->getLastError());
}
/**
 * Samples for Perform ServiceType
 */
$perform = new \patest\ServiceType\Perform($options);
$perform->setSoapHeaderContext(new \patest\StructType\Context());
$perform->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for PerformPolling operation/method
 */
if ($perform->PerformPolling(new \patest\StructType\PerformPollingRequest()) !== false) {
    print_r($perform->getResult());
} else {
    print_r($perform->getLastError());
}
/**
 * Sample call for PerformProcessControlAction operation/method
 */
if ($perform->PerformProcessControlAction(new \patest\StructType\PerformProcessControlActionRequest()) !== false) {
    print_r($perform->getResult());
} else {
    print_r($perform->getLastError());
}
/**
 * Samples for Prepare ServiceType
 */
$prepare = new \patest\ServiceType\Prepare($options);
$prepare->setSoapHeaderContext(new \patest\StructType\Context());
$prepare->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for PrepareBizActionRequest operation/method
 */
if ($prepare->PrepareBizActionRequest(new \patest\StructType\PrepareBizActionRequestRequest()) !== false) {
    print_r($prepare->getResult());
} else {
    print_r($prepare->getLastError());
}
/**
 * Sample call for PrepareInitiateSubscriptionsRenewalRequest operation/method
 */
if ($prepare->PrepareInitiateSubscriptionsRenewalRequest(new \patest\StructType\PrepareInitiateSubscriptionsRenewalRequestRequest()) !== false) {
    print_r($prepare->getResult());
} else {
    print_r($prepare->getLastError());
}
/**
 * Sample call for PrepareEffectiveAvailabilityFilterToken operation/method
 */
if ($prepare->PrepareEffectiveAvailabilityFilterToken(new \patest\StructType\PrepareEffectiveAvailabilityFilterTokenRequest()) !== false) {
    print_r($prepare->getResult());
} else {
    print_r($prepare->getLastError());
}
/**
 * Sample call for PrepareAvailabilityFilterForHospitality operation/method
 */
if ($prepare->PrepareAvailabilityFilterForHospitality(new \patest\StructType\PrepareAvailabilityFilterForHospitalityRequest()) !== false) {
    print_r($prepare->getResult());
} else {
    print_r($prepare->getLastError());
}
/**
 * Sample call for PrepareEventAvailabilityFilterForCoupon operation/method
 */
if ($prepare->PrepareEventAvailabilityFilterForCoupon(new \patest\StructType\PrepareEventAvailabilityFilterForCouponRequest()) !== false) {
    print_r($prepare->getResult());
} else {
    print_r($prepare->getLastError());
}
/**
 * Sample call for PrepareSeriesAvailabilityFilterForCoupon operation/method
 */
if ($prepare->PrepareSeriesAvailabilityFilterForCoupon(new \patest\StructType\PrepareSeriesAvailabilityFilterForCouponRequest()) !== false) {
    print_r($prepare->getResult());
} else {
    print_r($prepare->getLastError());
}
/**
 * Sample call for PrepareAvailabilityFilterForBundleElement operation/method
 */
if ($prepare->PrepareAvailabilityFilterForBundleElement(new \patest\StructType\PrepareAvailabilityFilterForBundleElementRequest()) !== false) {
    print_r($prepare->getResult());
} else {
    print_r($prepare->getLastError());
}
/**
 * Samples for Manipulate ServiceType
 */
$manipulate = new \patest\ServiceType\Manipulate($options);
$manipulate->setSoapHeaderContext(new \patest\StructType\Context());
$manipulate->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for ManipulateBizActionRequest operation/method
 */
if ($manipulate->ManipulateBizActionRequest(new \patest\StructType\ManipulateBizActionRequestRequest()) !== false) {
    print_r($manipulate->getResult());
} else {
    print_r($manipulate->getLastError());
}
/**
 * Sample call for ManipulateChunkedRetrieve operation/method
 */
if ($manipulate->ManipulateChunkedRetrieve(new \patest\StructType\ManipulateChunkedRetrieveRequest()) !== false) {
    print_r($manipulate->getResult());
} else {
    print_r($manipulate->getLastError());
}
/**
 * Samples for Execute ServiceType
 */
$execute = new \patest\ServiceType\Execute($options);
$execute->setSoapHeaderContext(new \patest\StructType\Context());
$execute->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for ExecuteBizAction operation/method
 */
if ($execute->ExecuteBizAction(new \patest\StructType\ExecuteBizActionRequest()) !== false) {
    print_r($execute->getResult());
} else {
    print_r($execute->getLastError());
}
/**
 * Sample call for ExecuteScheduledInstallment operation/method
 */
if ($execute->ExecuteScheduledInstallment(new \patest\StructType\ExecuteScheduledInstallmentRequest()) !== false) {
    print_r($execute->getResult());
} else {
    print_r($execute->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \patest\ServiceType\Set($options);
$set->setSoapHeaderContext(new \patest\StructType\Context());
$set->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for SetUniversalFlag operation/method
 */
if ($set->SetUniversalFlag(new \patest\StructType\SetUniversalFlagRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetSubscriptionExtraEvents operation/method
 */
if ($set->SetSubscriptionExtraEvents(new \patest\StructType\SetSubscriptionExtraEventsRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetPrintOptionsForBasketSale operation/method
 */
if ($set->SetPrintOptionsForBasketSale(new \patest\StructType\SetPrintOptionsForBasketSale_Request()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetPrintOptionsForBasketSalesBatch operation/method
 */
if ($set->SetPrintOptionsForBasketSalesBatch(new \patest\StructType\SetPrintOptionsForBasketSalesBatch_Request()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetPrintOptionsForFollowUpBasketPrint operation/method
 */
if ($set->SetPrintOptionsForFollowUpBasketPrint(new \patest\StructType\SetPrintOptionsForFollowUpBasketPrint_Request()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetSecurityRole operation/method
 */
if ($set->SetSecurityRole(new \patest\StructType\SetSecurityRole_Request()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetUserApplicationPreference operation/method
 */
if ($set->SetUserApplicationPreference(new \patest\StructType\SetUserApplicationPreference_Request()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetTicketSchemeEnrollmentsOfBasketSubscriptions operation/method
 */
if ($set->SetTicketSchemeEnrollmentsOfBasketSubscriptions(new \patest\StructType\SetTicketSchemeEnrollmentsOfBasketSubscriptionsRequest()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetHospitalityTickets operation/method
 */
if ($set->SetHospitalityTickets(new \patest\StructType\SetHospitalityTickets_Request()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetHospitalitySubscriptions operation/method
 */
if ($set->SetHospitalitySubscriptions(new \patest\StructType\SetHospitalitySubscriptions_Request()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Query ServiceType
 */
$query = new \patest\ServiceType\Query($options);
$query->setSoapHeaderContext(new \patest\StructType\Context());
$query->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for QueryUniversalFlag operation/method
 */
if ($query->QueryUniversalFlag(new \patest\StructType\QueryUniversalFlagRequest()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for QueryGlobalMonitorsOffline operation/method
 */
if ($query->QueryGlobalMonitorsOffline(new \patest\StructType\QueryGlobalMonitorsOfflineRequest()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for QueryGlobalMonitorsOnline operation/method
 */
if ($query->QueryGlobalMonitorsOnline(new \patest\StructType\QueryGlobalMonitorsOnlineRequest()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for Query operation/method
 */
if ($query->Query(new \patest\StructType\EntitiesQueryRequest()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for QueryEntitiesFetchChunk operation/method
 */
if ($query->QueryEntitiesFetchChunk(new \patest\StructType\QueryEntitiesFetchChunkRequest()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for QueryIdentityPlatformProperties operation/method
 */
if ($query->QueryIdentityPlatformProperties(new \patest\StructType\QueryIdentityPlatformProperties_Request()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for QueryActivePaymentPlans operation/method
 */
if ($query->QueryActivePaymentPlans(new \patest\StructType\QueryActivePaymentPlansRequest()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for QueryTransaction operation/method
 */
if ($query->QueryTransaction(new \patest\StructType\QueryTransaction_Request()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for QueryTransactionState operation/method
 */
if ($query->QueryTransactionState(new \patest\StructType\QueryTransactionState_Request()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for QueryGroupOfTransactions operation/method
 */
if ($query->QueryGroupOfTransactions(new \patest\StructType\QueryGroupOfTransactions_Request()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for QueryPricingVariationsCatalog operation/method
 */
if ($query->QueryPricingVariationsCatalog(new \patest\StructType\QueryPricingVariationsCatalogRequest()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for QueryConnectionProperties operation/method
 */
if ($query->QueryConnectionProperties(new \patest\StructType\QueryConnectionProperties_Request()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for QueryParameters operation/method
 */
if ($query->QueryParameters(new \patest\StructType\QueryParameters_Request()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Sample call for QuerySeatingPlansAvailability operation/method
 */
if ($query->QuerySeatingPlansAvailability(new \patest\StructType\QueryMultipleSeatingPlansAvailabilityRequest()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \patest\ServiceType\Remove($options);
$remove->setSoapHeaderContext(new \patest\StructType\Context());
$remove->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for RemoveUniversalFlag operation/method
 */
if ($remove->RemoveUniversalFlag(new \patest\StructType\RemoveUniversalFlagRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveClient operation/method
 */
if ($remove->RemoveClient(new \patest\StructType\RemoveClientRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveClientTypeFromClients operation/method
 */
if ($remove->RemoveClientTypeFromClients(new \patest\StructType\RemoveClientTypeFromClientsRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveTicketsFromBasket operation/method
 */
if ($remove->RemoveTicketsFromBasket(new \patest\StructType\RemoveTicketsFromBasket_Request()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for RemoveCustomSeatPrices operation/method
 */
if ($remove->RemoveCustomSeatPrices(new \patest\StructType\RemoveCustomSeatPricesRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \patest\ServiceType\Add($options);
$add->setSoapHeaderContext(new \patest\StructType\Context());
$add->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for AddEntityManagementQueryTokenContext operation/method
 */
if ($add->AddEntityManagementQueryTokenContext(new \patest\StructType\AddEntityManagementQueryTokenContextRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddGuidanceToBasket operation/method
 */
if ($add->AddGuidanceToBasket(new \patest\StructType\AddGuidanceToBasketRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddTicketSchemeEnrollments operation/method
 */
if ($add->AddTicketSchemeEnrollments(new \patest\StructType\AddTicketSchemeEnrollments_Request()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddDeliveryToBasket operation/method
 */
if ($add->AddDeliveryToBasket(new \patest\StructType\AddDeliveryToBasket_Request()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddDonationToBasket operation/method
 */
if ($add->AddDonationToBasket(new \patest\StructType\AddDonationToBasket_Request()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddLinkedClient operation/method
 */
if ($add->AddLinkedClient(new \patest\StructType\AddLinkedClientRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddClientLink operation/method
 */
if ($add->AddClientLink(new \patest\StructType\AddClientLinkRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddCardLoadingToBasket operation/method
 */
if ($add->AddCardLoadingToBasket(new \patest\StructType\AddCardLoadingToBasketRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddGiftVouchersToBasket operation/method
 */
if ($add->AddGiftVouchersToBasket(new \patest\StructType\AddGiftVouchersToBasket_Request()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddMembershipsToBasket operation/method
 */
if ($add->AddMembershipsToBasket(new \patest\StructType\AddMembershipsToBasket_Request()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddMerchandisesToBasket operation/method
 */
if ($add->AddMerchandisesToBasket(new \patest\StructType\AddMerchandiseToBasket_Request()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddPaymentToBasket operation/method
 */
if ($add->AddPaymentToBasket(new \patest\StructType\AddPaymentToBasket_Request()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddCancellationPaymentToBasket operation/method
 */
if ($add->AddCancellationPaymentToBasket(new \patest\StructType\AddCancellationPaymentToBasket_Request()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddClientCreditToBasket operation/method
 */
if ($add->AddClientCreditToBasket(new \patest\StructType\AddClientCredit_Request()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddAdHocRefundToBasket operation/method
 */
if ($add->AddAdHocRefundToBasket(new \patest\StructType\AddAdHocRefundToBasket_Request()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddProductsToBasket operation/method
 */
if ($add->AddProductsToBasket(new \patest\StructType\AddProductsToBasketRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddBundleToBasket operation/method
 */
if ($add->AddBundleToBasket(new \patest\StructType\AddBundleToBasket_Request()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddPromptExtraProductsToBasket operation/method
 */
if ($add->AddPromptExtraProductsToBasket(new \patest\StructType\AddPromptExtraProductsToBasket_Request()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddDebtPaymentToBasket operation/method
 */
if ($add->AddDebtPaymentToBasket(new \patest\StructType\AddDebtPaymentToBasketRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddUnpayItemToBasket operation/method
 */
if ($add->AddUnpayItemToBasket(new \patest\StructType\AddUnpayItemToBasketRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddMultipleUnpayItemsToBasket operation/method
 */
if ($add->AddMultipleUnpayItemsToBasket(new \patest\StructType\AddMultipleUnpayItemsToBasketRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddDraftInvoiceContentToBasket operation/method
 */
if ($add->AddDraftInvoiceContentToBasket(new \patest\StructType\AddDraftInvoiceContentToBasketRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddInvoiceContentToBasket operation/method
 */
if ($add->AddInvoiceContentToBasket(new \patest\StructType\AddInvoiceContentToBasketRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddSubscriptionsToBasket operation/method
 */
if ($add->AddSubscriptionsToBasket(new \patest\StructType\AddSubscriptionsToBasketRequest()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddRelocationAddOnSubscriptions operation/method
 */
if ($add->AddRelocationAddOnSubscriptions(new \patest\StructType\AddRelocationAddOnSubscriptions_Request()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddTicketsToBasket operation/method
 */
if ($add->AddTicketsToBasket(new \patest\StructType\AddTicketsToBasket_Request()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddMultiEventTicketsToBasket operation/method
 */
if ($add->AddMultiEventTicketsToBasket(new \patest\StructType\AddMultiEventTicketsToBasket_Request()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddPriceListRuleToEvent operation/method
 */
if ($add->AddPriceListRuleToEvent(new \patest\StructType\AddPriceListRuleToEvent_Request()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddResaleTicketsToBasket operation/method
 */
if ($add->AddResaleTicketsToBasket(new \patest\StructType\AddResaleTicketsToBasket_Request()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddEventToTicketScheme operation/method
 */
if ($add->AddEventToTicketScheme(new \patest\StructType\AddEventToTicketScheme_Request()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddFullStackExchangeItemsToBasket operation/method
 */
if ($add->AddFullStackExchangeItemsToBasket(new \patest\StructType\AddFullStackExchangeItemsToBasket_Request()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddAccessCodesToPresale operation/method
 */
if ($add->AddAccessCodesToPresale(new \patest\StructType\AddAccessCodesToPresale_Request()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddAccessCodesToPresaleAsync operation/method
 */
if ($add->AddAccessCodesToPresaleAsync(new \patest\StructType\AddAccessCodesToPresale_Request()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Modify ServiceType
 */
$modify = new \patest\ServiceType\Modify($options);
$modify->setSoapHeaderContext(new \patest\StructType\Context());
$modify->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for ModifyEntityManagementQueryTokenContext operation/method
 */
if ($modify->ModifyEntityManagementQueryTokenContext(new \patest\StructType\ModifyEntityManagementQueryTokenContextRequest()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Sample call for ModifyTicketSchemeEnrollment operation/method
 */
if ($modify->ModifyTicketSchemeEnrollment(new \patest\StructType\ModifyTicketSchemeEnrollment_Request()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Samples for Revert ServiceType
 */
$revert = new \patest\ServiceType\Revert($options);
$revert->setSoapHeaderContext(new \patest\StructType\Context());
$revert->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for RevertEntityManagementQueryTokenContext operation/method
 */
if ($revert->RevertEntityManagementQueryTokenContext(new \patest\StructType\RevertEntityManagementQueryTokenContextRequest()) !== false) {
    print_r($revert->getResult());
} else {
    print_r($revert->getLastError());
}
/**
 * Samples for Invalidate ServiceType
 */
$invalidate = new \patest\ServiceType\Invalidate($options);
$invalidate->setSoapHeaderContext(new \patest\StructType\Context());
$invalidate->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for InvalidateEntityManagementQueryToken operation/method
 */
if ($invalidate->InvalidateEntityManagementQueryToken(new \patest\StructType\InvalidateEntityManagementQueryTokenRequest()) !== false) {
    print_r($invalidate->getResult());
} else {
    print_r($invalidate->getLastError());
}
/**
 * Sample call for InvalidateExpiredEntityManagementQueryTokens operation/method
 */
if ($invalidate->InvalidateExpiredEntityManagementQueryTokens(new \patest\StructType\InvalidateExpiredEntityManagementQueryTokensRequest()) !== false) {
    print_r($invalidate->getResult());
} else {
    print_r($invalidate->getLastError());
}
/**
 * Samples for Sync ServiceType
 */
$sync = new \patest\ServiceType\Sync($options);
$sync->setSoapHeaderContext(new \patest\StructType\Context());
$sync->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for SyncEntitiesFromExternalSource operation/method
 */
if ($sync->SyncEntitiesFromExternalSource(new \patest\StructType\SyncEntitiesFromExternalSourceRequest()) !== false) {
    print_r($sync->getResult());
} else {
    print_r($sync->getLastError());
}
/**
 * Sample call for SyncEntitiesFromExternalSourceEx operation/method
 */
if ($sync->SyncEntitiesFromExternalSourceEx(new \patest\StructType\SyncEntitiesFromExternalSourceRequestEx()) !== false) {
    print_r($sync->getResult());
} else {
    print_r($sync->getLastError());
}
/**
 * Sample call for SyncDeletedEntitiesFromExternalSource operation/method
 */
if ($sync->SyncDeletedEntitiesFromExternalSource(new \patest\StructType\SyncDeletedEntitiesFromExternalSourceRequest()) !== false) {
    print_r($sync->getResult());
} else {
    print_r($sync->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \patest\ServiceType\Update($options);
$update->setSoapHeaderContext(new \patest\StructType\Context());
$update->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for UpdateExternalIds operation/method
 */
if ($update->UpdateExternalIds(new \patest\StructType\UpdateExternalIdsRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateGlobalMonitors operation/method
 */
if ($update->UpdateGlobalMonitors(new \patest\StructType\UpdateGlobalMonitorsRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateSubscription operation/method
 */
if ($update->UpdateSubscription(new \patest\StructType\UpdateSubscriptionRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for Update operation/method
 */
if ($update->Update(new \patest\StructType\EntitiesCreateOrUpdateRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateExternalAuthenticationData operation/method
 */
if ($update->UpdateExternalAuthenticationData(new \patest\StructType\UpdateExternalAuthenticationData_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCustomer operation/method
 */
if ($update->UpdateCustomer(new \patest\StructType\UpdateCustomerRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateAccount operation/method
 */
if ($update->UpdateAccount(new \patest\StructType\UpdateAccountRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateDeliveryItems operation/method
 */
if ($update->UpdateDeliveryItems(new \patest\StructType\UpdateDeliveryItems_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateDonationItemProperties operation/method
 */
if ($update->UpdateDonationItemProperties(new \patest\StructType\UpdateDonationItemProperties_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateClientLink operation/method
 */
if ($update->UpdateClientLink(new \patest\StructType\UpdateClientLinkRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateMembershipItemProperties operation/method
 */
if ($update->UpdateMembershipItemProperties(new \patest\StructType\UpdateMembershipItemProperties_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCommittedMembershipItemProperties operation/method
 */
if ($update->UpdateCommittedMembershipItemProperties(new \patest\StructType\UpdateCommittedMembershipItemProperties_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateDirectDebitRecordStatus operation/method
 */
if ($update->UpdateDirectDebitRecordStatus(new \patest\StructType\UpdateDirectDebitRecordStatus_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdatePaymentItemStatus operation/method
 */
if ($update->UpdatePaymentItemStatus(new \patest\StructType\UpdatePaymentItems_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdatePaymentItemProviderSpecificProperties operation/method
 */
if ($update->UpdatePaymentItemProviderSpecificProperties(new \patest\StructType\UpdatePaymentItemProviderSpecificPropertiesRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdatePaymentSessionState operation/method
 */
if ($update->UpdatePaymentSessionState(new \patest\StructType\UpdatePaymentSessionStateRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdatePaymentPlanInstallments operation/method
 */
if ($update->UpdatePaymentPlanInstallments(new \patest\StructType\UpdatePaymentPlanInstallments_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateDepositItemProperties operation/method
 */
if ($update->UpdateDepositItemProperties(new \patest\StructType\UpdateDepositItemProperties_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateUppConfiguration operation/method
 */
if ($update->UpdateUppConfiguration(new \patest\StructType\UpdateUppConfigurationRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateTransactionProperties operation/method
 */
if ($update->UpdateTransactionProperties(new \patest\StructType\UpdateTransactionProperties_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateItemProperties operation/method
 */
if ($update->UpdateItemProperties(new \patest\StructType\UpdateItemProperties_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCommittedTransactionProperties operation/method
 */
if ($update->UpdateCommittedTransactionProperties(new \patest\StructType\UpdateCommittedTransactionProperties_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCommittedItemProperties operation/method
 */
if ($update->UpdateCommittedItemProperties(new \patest\StructType\UpdateCommittedItemProperties_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateSoldItemsPrice operation/method
 */
if ($update->UpdateSoldItemsPrice(new \patest\StructType\UpdateSoldItemsPrice_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateConnectionProperties operation/method
 */
if ($update->UpdateConnectionProperties(new \patest\StructType\UpdateConnectionProperties_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateParameters operation/method
 */
if ($update->UpdateParameters(new \patest\StructType\UpdateParameters_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateSubscriptionItemProperties operation/method
 */
if ($update->UpdateSubscriptionItemProperties(new \patest\StructType\UpdateSubscriptionItemPropertiesRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateHallVersionStatus operation/method
 */
if ($update->UpdateHallVersionStatus(new \patest\StructType\UpdateHallVersionStatus_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateTicketItemProperties operation/method
 */
if ($update->UpdateTicketItemProperties(new \patest\StructType\UpdateTicketItemProperties_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateOfClientApprovalOfEnrollment operation/method
 */
if ($update->UpdateOfClientApprovalOfEnrollment(new \patest\StructType\UpdateOfClientApprovalOfEnrollment_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdatePresale operation/method
 */
if ($update->UpdatePresale(new \patest\StructType\UpdatePresale_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateOnsale operation/method
 */
if ($update->UpdateOnsale(new \patest\StructType\UpdateOnsale_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateAccessCodes operation/method
 */
if ($update->UpdateAccessCodes(new \patest\StructType\UpdateAccessCode_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdatePresalesRankWeight operation/method
 */
if ($update->UpdatePresalesRankWeight(new \patest\StructType\UpdatePresalesRankWeight_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCustomSeatPrices operation/method
 */
if ($update->UpdateCustomSeatPrices(new \patest\StructType\UpdateCustomSeatPricesRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateExistingTicketProperties operation/method
 */
if ($update->UpdateExistingTicketProperties(new \patest\StructType\UpdateExistingTicketProperties_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateEventTicketViewConfiguration operation/method
 */
if ($update->UpdateEventTicketViewConfiguration(new \patest\StructType\UpdateEventTicketViewConfiguration_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateTicketViewComponentById operation/method
 */
if ($update->UpdateTicketViewComponentById(new \patest\StructType\TicketViewComponentUpdate_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateTicketViewAssociation operation/method
 */
if ($update->UpdateTicketViewAssociation(new \patest\StructType\UpdateTicketViewAssociation_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateTicketViewConfigurationImage operation/method
 */
if ($update->UpdateTicketViewConfigurationImage(new \patest\StructType\UpdateTicketViewConfigurationImageRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateTicketViewAssociationPrioritiesByIds operation/method
 */
if ($update->UpdateTicketViewAssociationPrioritiesByIds(new \patest\StructType\UpdateTicketViewAssociationPrioritiesByIdsRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateSubscriptionInstancesMaxAllowedExchanges operation/method
 */
if ($update->UpdateSubscriptionInstancesMaxAllowedExchanges(new \patest\StructType\UpdateSubscriptionInstancesMaxAllowedExchanges_Request()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Log ServiceType
 */
$log = new \patest\ServiceType\Log($options);
$log->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
$log->setSoapHeaderContext(new \patest\StructType\Context());
/**
 * Sample call for LogBanner operation/method
 */
if ($log->LogBanner(new \patest\StructType\LogBannerRequest()) !== false) {
    print_r($log->getResult());
} else {
    print_r($log->getLastError());
}
/**
 * Sample call for LogIntoOrganizationUnit operation/method
 */
if ($log->LogIntoOrganizationUnit(new \patest\StructType\LogIntoOrganizationUnit_Request()) !== false) {
    print_r($log->getResult());
} else {
    print_r($log->getLastError());
}
/**
 * Sample call for LogWithdrawPendingTransferTicketsDetails operation/method
 */
if ($log->LogWithdrawPendingTransferTicketsDetails(new \patest\StructType\WithdrawPendingTransferTicketsDetails_Request()) !== false) {
    print_r($log->getResult());
} else {
    print_r($log->getLastError());
}
/**
 * Sample call for LogCancelPartyByTicketIdsDetails operation/method
 */
if ($log->LogCancelPartyByTicketIdsDetails(new \patest\StructType\CancelPartyByTicketIdsDetails_Request()) !== false) {
    print_r($log->getResult());
} else {
    print_r($log->getLastError());
}
/**
 * Samples for Subscribe ServiceType
 */
$subscribe = new \patest\ServiceType\Subscribe($options);
$subscribe->setSoapHeaderContext(new \patest\StructType\Context());
$subscribe->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for SubscribeForGlobalMonitors operation/method
 */
if ($subscribe->SubscribeForGlobalMonitors(new \patest\StructType\SubscribeForGlobalMonitorsRequest()) !== false) {
    print_r($subscribe->getResult());
} else {
    print_r($subscribe->getLastError());
}
/**
 * Sample call for SubscribeForTrace operation/method
 */
if ($subscribe->SubscribeForTrace(new \patest\StructType\SubscribeForTraceRequest()) !== false) {
    print_r($subscribe->getResult());
} else {
    print_r($subscribe->getLastError());
}
/**
 * Sample call for Subscribe operation/method
 */
if ($subscribe->Subscribe(new \patest\StructType\SubscribeRequest()) !== false) {
    print_r($subscribe->getResult());
} else {
    print_r($subscribe->getLastError());
}
/**
 * Samples for Unsubscribe ServiceType
 */
$unsubscribe = new \patest\ServiceType\Unsubscribe($options);
$unsubscribe->setSoapHeaderContext(new \patest\StructType\Context());
$unsubscribe->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for UnsubscribeFromGlobalMonitors operation/method
 */
if ($unsubscribe->UnsubscribeFromGlobalMonitors(new \patest\StructType\UnsubscribeFromGlobalMonitorsRequest()) !== false) {
    print_r($unsubscribe->getResult());
} else {
    print_r($unsubscribe->getLastError());
}
/**
 * Sample call for UnsubscribeFromTrace operation/method
 */
if ($unsubscribe->UnsubscribeFromTrace(new \patest\StructType\UnsubscribeFromTraceRequest()) !== false) {
    print_r($unsubscribe->getResult());
} else {
    print_r($unsubscribe->getLastError());
}
/**
 * Sample call for Unsubscribe operation/method
 */
if ($unsubscribe->Unsubscribe(new \patest\StructType\UnsubscribeRequest()) !== false) {
    print_r($unsubscribe->getResult());
} else {
    print_r($unsubscribe->getLastError());
}
/**
 * Samples for Store ServiceType
 */
$store = new \patest\ServiceType\Store($options);
$store->setSoapHeaderContext(new \patest\StructType\Context());
$store->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for StoreJournalEntries operation/method
 */
if ($store->StoreJournalEntries(new \patest\StructType\StoreJournalEntriesRequest()) !== false) {
    print_r($store->getResult());
} else {
    print_r($store->getLastError());
}
/**
 * Sample call for Store operation/method
 */
if ($store->Store(new \patest\StructType\EntitiesCreateOrUpdateRequest()) !== false) {
    print_r($store->getResult());
} else {
    print_r($store->getLastError());
}
/**
 * Sample call for StoreManuallyEnteredBarcodes operation/method
 */
if ($store->StoreManuallyEnteredBarcodes(new \patest\StructType\StoreManuallyEnteredBarcodesRequest()) !== false) {
    print_r($store->getResult());
} else {
    print_r($store->getLastError());
}
/**
 * Sample call for StoreCreditCardToken operation/method
 */
if ($store->StoreCreditCardToken(new \patest\StructType\StoreCreditCardTokenRequest()) !== false) {
    print_r($store->getResult());
} else {
    print_r($store->getLastError());
}
/**
 * Sample call for StoreHallVersionDesign operation/method
 */
if ($store->StoreHallVersionDesign(new \patest\StructType\StoreHallVersionDesign_Request()) !== false) {
    print_r($store->getResult());
} else {
    print_r($store->getLastError());
}
/**
 * Samples for Flush ServiceType
 */
$flush = new \patest\ServiceType\Flush($options);
$flush->setSoapHeaderContext(new \patest\StructType\Context());
$flush->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for FlushDump operation/method
 */
if ($flush->FlushDump(new \patest\StructType\FlushDumpRequest()) !== false) {
    print_r($flush->getResult());
} else {
    print_r($flush->getLastError());
}
/**
 * Samples for Reload ServiceType
 */
$reload = new \patest\ServiceType\Reload($options);
$reload->setSoapHeaderContext(new \patest\StructType\Context());
$reload->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for ReloadTenant operation/method
 */
if ($reload->ReloadTenant(new \patest\StructType\ReloadTenantRequest()) !== false) {
    print_r($reload->getResult());
} else {
    print_r($reload->getLastError());
}
/**
 * Samples for Start ServiceType
 */
$start = new \patest\ServiceType\Start($options);
$start->setSoapHeaderContext(new \patest\StructType\Context());
$start->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for StartTrace operation/method
 */
if ($start->StartTrace(new \patest\StructType\StartTraceRequest()) !== false) {
    print_r($start->getResult());
} else {
    print_r($start->getLastError());
}
/**
 * Sample call for StartStopPrintingServer operation/method
 */
if ($start->StartStopPrintingServer(new \patest\StructType\StartStopPrintingServer_Request()) !== false) {
    print_r($start->getResult());
} else {
    print_r($start->getLastError());
}
/**
 * Sample call for StartStopPrinter operation/method
 */
if ($start->StartStopPrinter(new \patest\StructType\StartStopPrinter_Request()) !== false) {
    print_r($start->getResult());
} else {
    print_r($start->getLastError());
}
/**
 * Samples for Pause ServiceType
 */
$pause = new \patest\ServiceType\Pause($options);
$pause->setSoapHeaderContext(new \patest\StructType\Context());
$pause->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for PauseTrace operation/method
 */
if ($pause->PauseTrace(new \patest\StructType\PauseTraceRequest()) !== false) {
    print_r($pause->getResult());
} else {
    print_r($pause->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \patest\ServiceType\Create($options);
$create->setSoapHeaderContext(new \patest\StructType\Context());
$create->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for Create operation/method
 */
if ($create->Create(new \patest\StructType\EntitiesCreateOrUpdateRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateBarcodeForProduct operation/method
 */
if ($create->CreateBarcodeForProduct(new \patest\StructType\CreateBarcodeForProduct_Request()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateExternalImportedBarcode operation/method
 */
if ($create->CreateExternalImportedBarcode(new \patest\StructType\CreateExternalImportedBarcode_Request()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateVisit operation/method
 */
if ($create->CreateVisit(new \patest\StructType\CreateVisitRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateCustomer operation/method
 */
if ($create->CreateCustomer(new \patest\StructType\CreateCustomerRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateAccount operation/method
 */
if ($create->CreateAccount(new \patest\StructType\CreateAccountRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreatePaymentTokenWithoutPayment operation/method
 */
if ($create->CreatePaymentTokenWithoutPayment(new \patest\StructType\CreatePaymentTokenWithoutPaymentRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateSession operation/method
 */
if ($create->CreateSession(new \patest\StructType\CreatePaymentContextRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreatePayment operation/method
 */
if ($create->CreatePayment(new \patest\StructType\CreatePaymentRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateNewTransaction operation/method
 */
if ($create->CreateNewTransaction(new \patest\StructType\CreateNewTransaction_Request()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateOrUpdatePriceList operation/method
 */
if ($create->CreateOrUpdatePriceList(new \patest\StructType\CreateOrUpdatePriceList_Request()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateDraftInvoices operation/method
 */
if ($create->CreateDraftInvoices(new \patest\StructType\CreateDraftInvoices_Request()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateOnsale operation/method
 */
if ($create->CreateOnsale(new \patest\StructType\CreateOnsale_Request()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreatePresale operation/method
 */
if ($create->CreatePresale(new \patest\StructType\CreatePresale_Request()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreatePresaleAsync operation/method
 */
if ($create->CreatePresaleAsync(new \patest\StructType\CreatePresale_Request()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateTicketViewComponent operation/method
 */
if ($create->CreateTicketViewComponent(new \patest\StructType\TicketViewComponentCreate_Request()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateTicketViewAssociation operation/method
 */
if ($create->CreateTicketViewAssociation(new \patest\StructType\CreateTicketViewAssociation_Request()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \patest\ServiceType\Delete($options);
$delete->setSoapHeaderContext(new \patest\StructType\Context());
$delete->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for Delete operation/method
 */
if ($delete->Delete(new \patest\StructType\EntitiesCreateOrUpdateRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteExternalAuthenticationData operation/method
 */
if ($delete->DeleteExternalAuthenticationData(new \patest\StructType\DeleteExternalAuthenticationData_Request()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteClient operation/method
 */
if ($delete->DeleteClient(new \patest\StructType\DeleteClient_Request()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteTicketSchemeEnrollment operation/method
 */
if ($delete->DeleteTicketSchemeEnrollment(new \patest\StructType\DeleteTicketSchemeEnrollment_Request()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteClientLink operation/method
 */
if ($delete->DeleteClientLink(new \patest\StructType\DeleteClientLinkRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteDirectDebitRecordBatch operation/method
 */
if ($delete->DeleteDirectDebitRecordBatch(new \patest\StructType\DeleteDirectDebitRecordsBatch_Request()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeletePresale operation/method
 */
if ($delete->DeletePresale(new \patest\StructType\DeletePresale_Request()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteBallotApplication operation/method
 */
if ($delete->DeleteBallotApplication(new \patest\StructType\DeleteBallotApplication_Request()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Initialize ServiceType
 */
$initialize = new \patest\ServiceType\Initialize($options);
$initialize->setSoapHeaderContext(new \patest\StructType\Context());
$initialize->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for InitializeWithDefaultValues operation/method
 */
if ($initialize->InitializeWithDefaultValues(new \patest\StructType\EntitiesInitRequest()) !== false) {
    print_r($initialize->getResult());
} else {
    print_r($initialize->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \patest\ServiceType\Validate($options);
$validate->setSoapHeaderContext(new \patest\StructType\Context());
$validate->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for ValidateBarcode operation/method
 */
if ($validate->ValidateBarcode(new \patest\StructType\ValidateBarcode_Request()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Sample call for ValidateTransactionAccessControlData operation/method
 */
if ($validate->ValidateTransactionAccessControlData(new \patest\StructType\ValidateTransactionAccessControlDataRequest()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Sample call for ValidateAddress operation/method
 */
if ($validate->ValidateAddress(new \patest\StructType\ValidateAddressRequest()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Sample call for ValidateContactDetail operation/method
 */
if ($validate->ValidateContactDetail(new \patest\StructType\ValidateContactDetail_Request()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Sample call for ValidateBatchBeforeProcess operation/method
 */
if ($validate->ValidateBatchBeforeProcess(new \patest\StructType\DonationValidateBatchBeforeProcessRequest()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Sample call for ValidateAndAddBundleToBasket operation/method
 */
if ($validate->ValidateAndAddBundleToBasket(new \patest\StructType\AddBundleToBasket_Request()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Sample call for ValidateBatchBeforeProcess_9905e58da5387f64870d1e0aa540532d
 * operation/method
 */
if ($validate->ValidateBatchBeforeProcess_9905e58da5387f64870d1e0aa540532d(new \patest\StructType\MembershipValidateBatchBeforeProcessRequest()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Sample call for ValidateTransaction operation/method
 */
if ($validate->ValidateTransaction(new \patest\StructType\ValidateTransaction_Request()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Sample call for ValidateSelectedProductsForBundle operation/method
 */
if ($validate->ValidateSelectedProductsForBundle(new \patest\StructType\ValidateSelectedProductsForBundleRequest()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Sample call for ValidateJwtTokenForExternalService operation/method
 */
if ($validate->ValidateJwtTokenForExternalService(new \patest\StructType\ValidateJwtTokenForExternalService_Request()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Sample call for ValidateBreakingHallDesignChanges operation/method
 */
if ($validate->ValidateBreakingHallDesignChanges(new \patest\StructType\ValidateBreakingHallDesignChangesRequest()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Sample call for ValidateForClientContainedInAnotherBallotApplication
 * operation/method
 */
if ($validate->ValidateForClientContainedInAnotherBallotApplication(new \patest\StructType\ValidateForClientContainedInAnotherBallotApplicationRequest()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Sample call for ValidateForAnyClientsContainedInAnotherBallotApplication
 * operation/method
 */
if ($validate->ValidateForAnyClientsContainedInAnotherBallotApplication(new \patest\StructType\ValidateForAnyClientsContainedInAnotherBallotApplicationRequest()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Sample call for ValidateWithdrawPendingTransferTickets operation/method
 */
if ($validate->ValidateWithdrawPendingTransferTickets(new \patest\StructType\_x0020_WithdrawPendingTransferTickets_Request()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Samples for Test ServiceType
 */
$test = new \patest\ServiceType\Test($options);
$test->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for TestGetNextRandomBarcode operation/method
 */
if ($test->TestGetNextRandomBarcode(new \patest\StructType\TestGetNextRandomBarcodeRequest()) !== false) {
    print_r($test->getResult());
} else {
    print_r($test->getLastError());
}
/**
 * Samples for Rollback ServiceType
 */
$rollback = new \patest\ServiceType\Rollback($options);
$rollback->setSoapHeaderContext(new \patest\StructType\Context());
$rollback->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for RollbackManuallyEnteredBarcodes operation/method
 */
if ($rollback->RollbackManuallyEnteredBarcodes(new \patest\StructType\RollbackManuallyEnteredBarcodesRequest()) !== false) {
    print_r($rollback->getResult());
} else {
    print_r($rollback->getLastError());
}
/**
 * Sample call for RollbackTransaction operation/method
 */
if ($rollback->RollbackTransaction(new \patest\StructType\RollbackTransaction_Request()) !== false) {
    print_r($rollback->getResult());
} else {
    print_r($rollback->getLastError());
}
/**
 * Samples for Report ServiceType
 */
$report = new \patest\ServiceType\Report($options);
$report->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for ReportExternalBarcodeUsages operation/method
 */
if ($report->ReportExternalBarcodeUsages(new \patest\StructType\ReportExternalBarcodeUsagesRequest()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Sample call for ReportOfflineScanBarcodeUsages operation/method
 */
if ($report->ReportOfflineScanBarcodeUsages(new \patest\StructType\ReportOfflineScanBarcodeUsagesRequest()) !== false) {
    print_r($report->getResult());
} else {
    print_r($report->getLastError());
}
/**
 * Samples for Load ServiceType
 */
$load = new \patest\ServiceType\Load($options);
$load->setSoapHeaderContext(new \patest\StructType\Context());
$load->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for LoadTicketsToAccessCard operation/method
 */
if ($load->LoadTicketsToAccessCard(new \patest\StructType\LoadTicketsToAccessCard_Request()) !== false) {
    print_r($load->getResult());
} else {
    print_r($load->getLastError());
}
/**
 * Sample call for LoadEventAccessControlManager operation/method
 */
if ($load->LoadEventAccessControlManager(new \patest\StructType\LoadEventAccessControlManagerRequest()) !== false) {
    print_r($load->getResult());
} else {
    print_r($load->getLastError());
}
/**
 * Sample call for LoadPaymentItems operation/method
 */
if ($load->LoadPaymentItems(new \patest\StructType\LoadPaymentItemsRequest()) !== false) {
    print_r($load->getResult());
} else {
    print_r($load->getLastError());
}
/**
 * Samples for Scan ServiceType
 */
$scan = new \patest\ServiceType\Scan($options);
$scan->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for ScanBarcode operation/method
 */
if ($scan->ScanBarcode(new \patest\StructType\ScanBarcodeRequest()) !== false) {
    print_r($scan->getResult());
} else {
    print_r($scan->getLastError());
}
/**
 * Samples for Unload ServiceType
 */
$unload = new \patest\ServiceType\Unload($options);
$unload->setSoapHeaderContext(new \patest\StructType\Context());
$unload->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for UnloadEventAccessControlManager operation/method
 */
if ($unload->UnloadEventAccessControlManager(new \patest\StructType\UnloadEventAccessControlManagerRequest()) !== false) {
    print_r($unload->getResult());
} else {
    print_r($unload->getLastError());
}
/**
 * Samples for Open ServiceType
 */
$open = new \patest\ServiceType\Open($options);
$open->setSoapHeaderContext(new \patest\StructType\Context());
$open->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for OpenScanningSession operation/method
 */
if ($open->OpenScanningSession(new \patest\StructType\OpenScanningSessionRequest()) !== false) {
    print_r($open->getResult());
} else {
    print_r($open->getLastError());
}
/**
 * Samples for Close ServiceType
 */
$close = new \patest\ServiceType\Close($options);
$close->setSoapHeaderContext(new \patest\StructType\Context());
$close->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for CloseScanningSession operation/method
 */
if ($close->CloseScanningSession(new \patest\StructType\CloseScanningSessionRequest()) !== false) {
    print_r($close->getResult());
} else {
    print_r($close->getLastError());
}
/**
 * Sample call for CloseShifts operation/method
 */
if ($close->CloseShifts(new \patest\StructType\CloseShifts_Request()) !== false) {
    print_r($close->getResult());
} else {
    print_r($close->getLastError());
}
/**
 * Sample call for CloseEventsForSale operation/method
 */
if ($close->CloseEventsForSale(new \patest\StructType\CloseEventsForSale_Request()) !== false) {
    print_r($close->getResult());
} else {
    print_r($close->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \patest\ServiceType\Change($options);
$change->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
$change->setSoapHeaderContext(new \patest\StructType\Context());
/**
 * Sample call for ChangePassword operation/method
 */
if ($change->ChangePassword(new \patest\StructType\ChangePassword_Request()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for ChangePassword_bfa29dc8f8aa3bfbb9f71d920d25c90b operation/method
 */
if ($change->ChangePassword_bfa29dc8f8aa3bfbb9f71d920d25c90b(new \patest\StructType\Crm_ChangePassword_Request()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for ChangeSubscriptionTicketsPriceType operation/method
 */
if ($change->ChangeSubscriptionTicketsPriceType(new \patest\StructType\ChangeSubscriptionTicketsPriceType_Request()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for ChangeOfOwnership operation/method
 */
if ($change->ChangeOfOwnership(new \patest\StructType\ChangeOfOwnershipRequest()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for ChangeTicketOwner operation/method
 */
if ($change->ChangeTicketOwner(new \patest\StructType\ChangeTicketOwnerRequest()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Reset ServiceType
 */
$reset = new \patest\ServiceType\Reset($options);
$reset->setSoapHeaderContext(new \patest\StructType\Context());
$reset->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for ResetPassword operation/method
 */
if ($reset->ResetPassword(new \patest\StructType\ResetPassword_Request()) !== false) {
    print_r($reset->getResult());
} else {
    print_r($reset->getLastError());
}
/**
 * Sample call for ResetPassword_a0d8cd5502aa15b18bb2ee4851eb7b63 operation/method
 */
if ($reset->ResetPassword_a0d8cd5502aa15b18bb2ee4851eb7b63(new \patest\StructType\Crm_ResetPassword_Request()) !== false) {
    print_r($reset->getResult());
} else {
    print_r($reset->getLastError());
}
/**
 * Samples for Lookup ServiceType
 */
$lookup = new \patest\ServiceType\Lookup($options);
$lookup->setSoapHeaderContext(new \patest\StructType\Context());
$lookup->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for LookupExternalAuthenticationData operation/method
 */
if ($lookup->LookupExternalAuthenticationData(new \patest\StructType\LookupExternalAuthenticationData_Request()) !== false) {
    print_r($lookup->getResult());
} else {
    print_r($lookup->getLastError());
}
/**
 * Sample call for LookupExternalAuthenticationDataByUser operation/method
 */
if ($lookup->LookupExternalAuthenticationDataByUser(new \patest\StructType\LookupExternalAuthenticationDataByUser_Request()) !== false) {
    print_r($lookup->getResult());
} else {
    print_r($lookup->getLastError());
}
/**
 * Samples for Extract ServiceType
 */
$extract = new \patest\ServiceType\Extract($options);
$extract->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for ExtractAuthenticationDataFromIdentityProviderFormPost
 * operation/method
 */
if ($extract->ExtractAuthenticationDataFromIdentityProviderFormPost(new \patest\StructType\ExtractAuthenticationDataFromIdentityProviderFormPost_Request()) !== false) {
    print_r($extract->getResult());
} else {
    print_r($extract->getLastError());
}
/**
 * Samples for Generate ServiceType
 */
$generate = new \patest\ServiceType\Generate($options);
$generate->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
$generate->setSoapHeaderContext(new \patest\StructType\Context());
/**
 * Sample call for GenerateOTP operation/method
 */
if ($generate->GenerateOTP(new \patest\StructType\GenerateOTP_Request()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for GenerateBarcodes operation/method
 */
if ($generate->GenerateBarcodes(new \patest\StructType\GenerateBarcodes_Request()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for GenerateBarcodesAsync operation/method
 */
if ($generate->GenerateBarcodesAsync(new \patest\StructType\GenerateBarcodesAsync_Request()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Samples for Book ServiceType
 */
$book = new \patest\ServiceType\Book($options);
$book->setSoapHeaderContext(new \patest\StructType\Context());
$book->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for BookVisit operation/method
 */
if ($book->BookVisit(new \patest\StructType\BookVisitRequest()) !== false) {
    print_r($book->getResult());
} else {
    print_r($book->getLastError());
}
/**
 * Samples for Unbook ServiceType
 */
$unbook = new \patest\ServiceType\Unbook($options);
$unbook->setSoapHeaderContext(new \patest\StructType\Context());
$unbook->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for UnbookVisit operation/method
 */
if ($unbook->UnbookVisit(new \patest\StructType\UnbookVisitRequest()) !== false) {
    print_r($unbook->getResult());
} else {
    print_r($unbook->getLastError());
}
/**
 * Samples for Upgrade ServiceType
 */
$upgrade = new \patest\ServiceType\Upgrade($options);
$upgrade->setSoapHeaderContext(new \patest\StructType\Context());
$upgrade->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for UpgradeCustomerToAccount operation/method
 */
if ($upgrade->UpgradeCustomerToAccount(new \patest\StructType\UpgradeCustomerToAccount_Request()) !== false) {
    print_r($upgrade->getResult());
} else {
    print_r($upgrade->getLastError());
}
/**
 * Sample call for UpgradeTickets operation/method
 */
if ($upgrade->UpgradeTickets(new \patest\StructType\UpgradeTickets_Request()) !== false) {
    print_r($upgrade->getResult());
} else {
    print_r($upgrade->getLastError());
}
/**
 * Samples for Merge ServiceType
 */
$merge = new \patest\ServiceType\Merge($options);
$merge->setSoapHeaderContext(new \patest\StructType\Context());
$merge->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for MergeClients operation/method
 */
if ($merge->MergeClients(new \patest\StructType\MergeClients_Request()) !== false) {
    print_r($merge->getResult());
} else {
    print_r($merge->getLastError());
}
/**
 * Samples for Verify ServiceType
 */
$verify = new \patest\ServiceType\Verify($options);
$verify->setSoapHeaderContext(new \patest\StructType\Context());
$verify->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for VerifyLogin operation/method
 */
if ($verify->VerifyLogin(new \patest\StructType\VerifyLogin_Request()) !== false) {
    print_r($verify->getResult());
} else {
    print_r($verify->getLastError());
}
/**
 * Sample call for VerifyAccount operation/method
 */
if ($verify->VerifyAccount(new \patest\StructType\VerifyAccount_Request()) !== false) {
    print_r($verify->getResult());
} else {
    print_r($verify->getLastError());
}
/**
 * Sample call for VerifyAndSaveDeviceIds operation/method
 */
if ($verify->VerifyAndSaveDeviceIds(new \patest\StructType\VerifyAndSaveDeviceIdsRequest()) !== false) {
    print_r($verify->getResult());
} else {
    print_r($verify->getLastError());
}
/**
 * Sample call for VerifyTicketIsForwardableToOwner operation/method
 */
if ($verify->VerifyTicketIsForwardableToOwner(new \patest\StructType\VerifyTicketIsForwardableToOwnerRequest()) !== false) {
    print_r($verify->getResult());
} else {
    print_r($verify->getLastError());
}
/**
 * Samples for Login ServiceType
 */
$login = new \patest\ServiceType\Login($options);
$login->setSoapHeaderContext(new \patest\StructType\Context());
$login->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for LoginClient operation/method
 */
if ($login->LoginClient(new \patest\StructType\LoginClient_Request()) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Sample call for LoginClientV2 operation/method
 */
if ($login->LoginClientV2(new \patest\StructType\LoginClient_Request_V2()) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Logout ServiceType
 */
$logout = new \patest\ServiceType\Logout($options);
$logout->setSoapHeaderContext(new \patest\StructType\Context());
$logout->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for LogoutClient operation/method
 */
if ($logout->LogoutClient(new \patest\StructType\LogoutClient_Request()) !== false) {
    print_r($logout->getResult());
} else {
    print_r($logout->getLastError());
}
/**
 * Samples for Address ServiceType
 */
$address = new \patest\ServiceType\Address($options);
$address->setSoapHeaderContext(new \patest\StructType\Context());
$address->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for AddressSearch operation/method
 */
if ($address->AddressSearch(new \patest\StructType\AddressSearchRequest()) !== false) {
    print_r($address->getResult());
} else {
    print_r($address->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \patest\ServiceType\Check($options);
$check->setSoapHeaderContext(new \patest\StructType\Context());
$check->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for CheckClientDuplications operation/method
 */
if ($check->CheckClientDuplications(new \patest\StructType\CheckClientDuplicationsRequest()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for CheckTicketsForHolder operation/method
 */
if ($check->CheckTicketsForHolder(new \patest\StructType\CheckTicketsForHolderRequest()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for CheckSGOServicesStatus operation/method
 */
if ($check->CheckSGOServicesStatus(new \patest\StructType\CheckSGOServicesStatusRequest_Request()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for CheckAccessCodes operation/method
 */
if ($check->CheckAccessCodes(new \patest\StructType\CheckAccessCodes_Request()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Sample call for CheckPresaleNameDuplication operation/method
 */
if ($check->CheckPresaleNameDuplication(new \patest\StructType\CheckPresaleNameDuplication_Request()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Resolve ServiceType
 */
$resolve = new \patest\ServiceType\Resolve($options);
$resolve->setSoapHeaderContext(new \patest\StructType\Context());
$resolve->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for ResolveClientNameBySalutationFormat operation/method
 */
if ($resolve->ResolveClientNameBySalutationFormat(new \patest\StructType\ResolveClientNameBySalutationFormatRequest()) !== false) {
    print_r($resolve->getResult());
} else {
    print_r($resolve->getLastError());
}
/**
 * Sample call for ResolveCouponByNumber operation/method
 */
if ($resolve->ResolveCouponByNumber(new \patest\StructType\ResolveCouponByNumber_Request()) !== false) {
    print_r($resolve->getResult());
} else {
    print_r($resolve->getLastError());
}
/**
 * Sample call for ResolvePresaleByCode operation/method
 */
if ($resolve->ResolvePresaleByCode(new \patest\StructType\ResolvePresaleByCode_Request()) !== false) {
    print_r($resolve->getResult());
} else {
    print_r($resolve->getLastError());
}
/**
 * Samples for Retrieve ServiceType
 */
$retrieve = new \patest\ServiceType\Retrieve($options);
$retrieve->setSoapHeaderContext(new \patest\StructType\Context());
$retrieve->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for RetrieveCustomer operation/method
 */
if ($retrieve->RetrieveCustomer(new \patest\StructType\RetrieveCustomerRequest()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveAccount operation/method
 */
if ($retrieve->RetrieveAccount(new \patest\StructType\RetrieveAccountRequest()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveClientPurchases operation/method
 */
if ($retrieve->RetrieveClientPurchases(new \patest\StructType\RetrieveClientPurchasesRequest()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveSalesItems operation/method
 */
if ($retrieve->RetrieveSalesItems(new \patest\StructType\RetrieveSalesItemsRequest()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Sample call for RetrieveHallVersionDesign operation/method
 */
if ($retrieve->RetrieveHallVersionDesign(new \patest\StructType\RetrieveHallVersionDesign_Request()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Samples for Notify ServiceType
 */
$notify = new \patest\ServiceType\Notify($options);
$notify->setSoapHeaderContext(new \patest\StructType\Context());
$notify->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for NotifyClientByEmail operation/method
 */
if ($notify->NotifyClientByEmail(new \patest\StructType\NotifyClientByEmail_Request()) !== false) {
    print_r($notify->getResult());
} else {
    print_r($notify->getLastError());
}
/**
 * Samples for Begin ServiceType
 */
$begin = new \patest\ServiceType\Begin($options);
$begin->setSoapHeaderContext(new \patest\StructType\Context());
$begin->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for BeginCustomerRegistration operation/method
 */
if ($begin->BeginCustomerRegistration(new \patest\StructType\BeginCustomerRegistration_Request()) !== false) {
    print_r($begin->getResult());
} else {
    print_r($begin->getLastError());
}
/**
 * Samples for Apply ServiceType
 */
$apply = new \patest\ServiceType\Apply($options);
$apply->setSoapHeaderContext(new \patest\StructType\Context());
$apply->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for ApplyClientTypeToClients operation/method
 */
if ($apply->ApplyClientTypeToClients(new \patest\StructType\ApplyClientTypeToClientsRequest()) !== false) {
    print_r($apply->getResult());
} else {
    print_r($apply->getLastError());
}
/**
 * Sample call for ApplyChangeToPaymentPlanInstallments operation/method
 */
if ($apply->ApplyChangeToPaymentPlanInstallments(new \patest\StructType\ApplyChangeToPaymentPlanInstallments_Request()) !== false) {
    print_r($apply->getResult());
} else {
    print_r($apply->getLastError());
}
/**
 * Sample call for ApplyLayers operation/method
 */
if ($apply->ApplyLayers(new \patest\StructType\ApplyLayer_Request()) !== false) {
    print_r($apply->getResult());
} else {
    print_r($apply->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \patest\ServiceType\Send($options);
$send->setSoapHeaderContext(new \patest\StructType\Context());
$send->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for SendRelationshipInvitation operation/method
 */
if ($send->SendRelationshipInvitation(new \patest\StructType\SendRelationshipInvitation_Request()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendBasketToPrint operation/method
 */
if ($send->SendBasketToPrint(new \patest\StructType\SendBasketToPrint_Request()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendBasketToPrintStandalone operation/method
 */
if ($send->SendBasketToPrintStandalone(new \patest\StructType\SendBasketToPrintStandalone_Request()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendAdHocDocumentsToPrint operation/method
 */
if ($send->SendAdHocDocumentsToPrint(new \patest\StructType\SendAdHocDocumentsToPrint_Request()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendBasketSalesBatchToPrint operation/method
 */
if ($send->SendBasketSalesBatchToPrint(new \patest\StructType\SendBasketSalesBatchToPrint_Request()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Sample call for SendFollowUpBasketToPrint operation/method
 */
if ($send->SendFollowUpBasketToPrint(new \patest\StructType\SendFollowUpBasketToPrint_Request()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Accept ServiceType
 */
$accept = new \patest\ServiceType\Accept($options);
$accept->setSoapHeaderContext(new \patest\StructType\Context());
$accept->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for AcceptRelationshipInvitation operation/method
 */
if ($accept->AcceptRelationshipInvitation(new \patest\StructType\AcceptRelationshipInvitation_Request()) !== false) {
    print_r($accept->getResult());
} else {
    print_r($accept->getLastError());
}
/**
 * Samples for Reject ServiceType
 */
$reject = new \patest\ServiceType\Reject($options);
$reject->setSoapHeaderContext(new \patest\StructType\Context());
$reject->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for RejectRelationshipInvitation operation/method
 */
if ($reject->RejectRelationshipInvitation(new \patest\StructType\RejectRelationshipInvitation_Request()) !== false) {
    print_r($reject->getResult());
} else {
    print_r($reject->getLastError());
}
/**
 * Samples for Fetch ServiceType
 */
$fetch = new \patest\ServiceType\Fetch($options);
$fetch->setSoapHeaderContext(new \patest\StructType\Context());
$fetch->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for FetchClientPassPhrase operation/method
 */
if ($fetch->FetchClientPassPhrase(new \patest\StructType\FetchClientPassPhrasesRequest()) !== false) {
    print_r($fetch->getResult());
} else {
    print_r($fetch->getLastError());
}
/**
 * Samples for Refresh ServiceType
 */
$refresh = new \patest\ServiceType\Refresh($options);
$refresh->setSoapHeaderContext(new \patest\StructType\Context());
$refresh->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for RefreshClientPassPhrase operation/method
 */
if ($refresh->RefreshClientPassPhrase(new \patest\StructType\RefreshClientPassPhrasesRequest()) !== false) {
    print_r($refresh->getResult());
} else {
    print_r($refresh->getLastError());
}
/**
 * Samples for Trigger ServiceType
 */
$trigger = new \patest\ServiceType\Trigger($options);
$trigger->setSoapHeaderContext(new \patest\StructType\Context());
$trigger->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for TriggerAccountLink operation/method
 */
if ($trigger->TriggerAccountLink(new \patest\StructType\TriggerAccountLinkRequest()) !== false) {
    print_r($trigger->getResult());
} else {
    print_r($trigger->getLastError());
}
/**
 * Sample call for TriggerAccountLinkingEmail operation/method
 */
if ($trigger->TriggerAccountLinkingEmail(new \patest\StructType\TriggerAccountLinkingEmailRequest()) !== false) {
    print_r($trigger->getResult());
} else {
    print_r($trigger->getLastError());
}
/**
 * Samples for Search ServiceType
 */
$search = new \patest\ServiceType\Search($options);
$search->setSoapHeaderContext(new \patest\StructType\Context());
$search->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for Search operation/method
 */
if ($search->Search(new \patest\StructType\CrossServiceSearchFacade_Request()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchForMatchingGiftsOptions operation/method
 */
if ($search->SearchForMatchingGiftsOptions(new \patest\StructType\SearchForMatchingGiftsOptions_Request()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Sample call for SearchAccessCodes operation/method
 */
if ($search->SearchAccessCodes(new \patest\StructType\SearchAccessCodes_Request()) !== false) {
    print_r($search->getResult());
} else {
    print_r($search->getLastError());
}
/**
 * Samples for Run ServiceType
 */
$run = new \patest\ServiceType\Run($options);
$run->setSoapHeaderContext(new \patest\StructType\Context());
$run->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for RunBatchProcess operation/method
 */
if ($run->RunBatchProcess(new \patest\StructType\DonaitonRunBatchProcessRequest()) !== false) {
    print_r($run->getResult());
} else {
    print_r($run->getLastError());
}
/**
 * Sample call for RunBatchProcess_327b3578629ac6b65e8d8d457a6e3288
 * operation/method
 */
if ($run->RunBatchProcess_327b3578629ac6b65e8d8d457a6e3288(new \patest\StructType\MembershipRunBatchProcessRequest()) !== false) {
    print_r($run->getResult());
} else {
    print_r($run->getLastError());
}
/**
 * Samples for Populate ServiceType
 */
$populate = new \patest\ServiceType\Populate($options);
$populate->setSoapHeaderContext(new \patest\StructType\Context());
$populate->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for PopulateSubscriptionTicketsListForAction operation/method
 */
if ($populate->PopulateSubscriptionTicketsListForAction(new \patest\StructType\PopulateSubscriptionTicketsListForActionRequest()) !== false) {
    print_r($populate->getResult());
} else {
    print_r($populate->getLastError());
}
/**
 * Samples for Replace ServiceType
 */
$replace = new \patest\ServiceType\Replace($options);
$replace->setSoapHeaderContext(new \patest\StructType\Context());
$replace->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for ReplaceSubscritpionTicketSeat operation/method
 */
if ($replace->ReplaceSubscritpionTicketSeat(new \patest\StructType\ReplaceSubscritpionTicketSeatRequest()) !== false) {
    print_r($replace->getResult());
} else {
    print_r($replace->getLastError());
}
/**
 * Sample call for ReplaceSubscriptionSeat operation/method
 */
if ($replace->ReplaceSubscriptionSeat(new \patest\StructType\ReplaceSubscriptionSeatRequest()) !== false) {
    print_r($replace->getResult());
} else {
    print_r($replace->getLastError());
}
/**
 * Samples for Publish ServiceType
 */
$publish = new \patest\ServiceType\Publish($options);
$publish->setSoapHeaderContext(new \patest\StructType\Context());
$publish->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for PublishEsroEvent operation/method
 */
if ($publish->PublishEsroEvent(new \patest\StructType\PublishEsroEventRequest()) !== false) {
    print_r($publish->getResult());
} else {
    print_r($publish->getLastError());
}
/**
 * Samples for Identify ServiceType
 */
$identify = new \patest\ServiceType\Identify($options);
$identify->setSoapHeaderContext(new \patest\StructType\Context());
$identify->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for IdentifyAndLinkClient operation/method
 */
if ($identify->IdentifyAndLinkClient(new \patest\StructType\IdentifyAndLinkClientRequest()) !== false) {
    print_r($identify->getResult());
} else {
    print_r($identify->getLastError());
}
/**
 * Samples for Card ServiceType
 */
$card = new \patest\ServiceType\Card($options);
$card->setSoapHeaderContext(new \patest\StructType\Context());
$card->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for CardInquiry operation/method
 */
if ($card->CardInquiry(new \patest\StructType\CardInquiryRequest()) !== false) {
    print_r($card->getResult());
} else {
    print_r($card->getLastError());
}
/**
 * Samples for Recheck ServiceType
 */
$recheck = new \patest\ServiceType\Recheck($options);
$recheck->setSoapHeaderContext(new \patest\StructType\Context());
$recheck->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for RecheckRenewalOfMembershipItems operation/method
 */
if ($recheck->RecheckRenewalOfMembershipItems(new \patest\StructType\RecheckRenewalOfMembershipItems_Request()) !== false) {
    print_r($recheck->getResult());
} else {
    print_r($recheck->getLastError());
}
/**
 * Samples for Withdraw ServiceType
 */
$withdraw = new \patest\ServiceType\Withdraw($options);
$withdraw->setSoapHeaderContext(new \patest\StructType\Context());
$withdraw->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for WithdrawDepositsToBasket operation/method
 */
if ($withdraw->WithdrawDepositsToBasket(new \patest\StructType\WithdrawDepositsToBasket_Request()) !== false) {
    print_r($withdraw->getResult());
} else {
    print_r($withdraw->getLastError());
}
/**
 * Sample call for WithdrawPendingTransferTickets operation/method
 */
if ($withdraw->WithdrawPendingTransferTickets(new \patest\StructType\_x0020_WithdrawPendingTransferTickets_Request()) !== false) {
    print_r($withdraw->getResult());
} else {
    print_r($withdraw->getLastError());
}
/**
 * Samples for Resume ServiceType
 */
$resume = new \patest\ServiceType\Resume($options);
$resume->setSoapHeaderContext(new \patest\StructType\Context());
$resume->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for ResumeAddPaymentItem operation/method
 */
if ($resume->ResumeAddPaymentItem(new \patest\StructType\ResumeAddPaymentToBasket_Request()) !== false) {
    print_r($resume->getResult());
} else {
    print_r($resume->getLastError());
}
/**
 * Sample call for ResumeHeldTransaction operation/method
 */
if ($resume->ResumeHeldTransaction(new \patest\StructType\ResumeHeldTransaction_Request()) !== false) {
    print_r($resume->getResult());
} else {
    print_r($resume->getLastError());
}
/**
 * Samples for Initiate ServiceType
 */
$initiate = new \patest\ServiceType\Initiate($options);
$initiate->setSoapHeaderContext(new \patest\StructType\Context());
$initiate->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for InitiateSearchPaymentServerSession operation/method
 */
if ($initiate->InitiateSearchPaymentServerSession(new \patest\StructType\InitiateSearchPaymentServerSession_Request()) !== false) {
    print_r($initiate->getResult());
} else {
    print_r($initiate->getLastError());
}
/**
 * Sample call for InitiatePaymentDataCollectionSession operation/method
 */
if ($initiate->InitiatePaymentDataCollectionSession(new \patest\StructType\InitiatePaymentDataCollectionSessionRequest()) !== false) {
    print_r($initiate->getResult());
} else {
    print_r($initiate->getLastError());
}
/**
 * Sample call for InitiatePaymentSession operation/method
 */
if ($initiate->InitiatePaymentSession(new \patest\StructType\InitiatePaymentSessionRequest()) !== false) {
    print_r($initiate->getResult());
} else {
    print_r($initiate->getLastError());
}
/**
 * Sample call for InitiateSubscriptionsRenewal operation/method
 */
if ($initiate->InitiateSubscriptionsRenewal(new \patest\StructType\InitiateSubscriptionsRenewalRequest()) !== false) {
    print_r($initiate->getResult());
} else {
    print_r($initiate->getLastError());
}
/**
 * Samples for Find ServiceType
 */
$find = new \patest\ServiceType\Find($options);
$find->setSoapHeaderContext(new \patest\StructType\Context());
$find->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for FindPaymentToken operation/method
 */
if ($find->FindPaymentToken(new \patest\StructType\FindPaymentToken_Request()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for FindShows operation/method
 */
if ($find->FindShows(new \patest\StructType\FindShows_Request()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Samples for Suggest ServiceType
 */
$suggest = new \patest\ServiceType\Suggest($options);
$suggest->setSoapHeaderContext(new \patest\StructType\Context());
$suggest->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for SuggestRefundOptions operation/method
 */
if ($suggest->SuggestRefundOptions(new \patest\StructType\SuggestRefundOptionsRequest()) !== false) {
    print_r($suggest->getResult());
} else {
    print_r($suggest->getLastError());
}
/**
 * Samples for Try ServiceType
 */
$try = new \patest\ServiceType\_Try($options);
$try->setSoapHeaderContext(new \patest\StructType\Context());
$try->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for TryAdjustInstallmentsAmount operation/method
 */
if ($try->TryAdjustInstallmentsAmount(new \patest\StructType\TryAdjustInstallmentsAmountRequest()) !== false) {
    print_r($try->getResult());
} else {
    print_r($try->getLastError());
}
/**
 * Samples for Batch ServiceType
 */
$batch = new \patest\ServiceType\Batch($options);
$batch->setSoapHeaderContext(new \patest\StructType\Context());
$batch->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for BatchPrint operation/method
 */
if ($batch->BatchPrint(new \patest\StructType\BatchPrintRequest()) !== false) {
    print_r($batch->getResult());
} else {
    print_r($batch->getLastError());
}
/**
 * Samples for Render ServiceType
 */
$render = new \patest\ServiceType\Render($options);
$render->setSoapHeaderContext(new \patest\StructType\Context());
$render->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for RenderDocuments operation/method
 */
if ($render->RenderDocuments(new \patest\StructType\RenderDocumentsRequest()) !== false) {
    print_r($render->getResult());
} else {
    print_r($render->getLastError());
}
/**
 * Samples for Print ServiceType
 */
$print = new \patest\ServiceType\_Print($options);
$print->setSoapHeaderContext(new \patest\StructType\Context());
$print->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for PrintInvoice operation/method
 */
if ($print->PrintInvoice(new \patest\StructType\PrintInvoiceRequest()) !== false) {
    print_r($print->getResult());
} else {
    print_r($print->getLastError());
}
/**
 * Samples for Commit ServiceType
 */
$commit = new \patest\ServiceType\Commit($options);
$commit->setSoapHeaderContext(new \patest\StructType\Context());
$commit->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for CommitTransaction operation/method
 */
if ($commit->CommitTransaction(new \patest\StructType\CommitTransaction_Request()) !== false) {
    print_r($commit->getResult());
} else {
    print_r($commit->getLastError());
}
/**
 * Samples for Compensate ServiceType
 */
$compensate = new \patest\ServiceType\Compensate($options);
$compensate->setSoapHeaderContext(new \patest\StructType\Context());
$compensate->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for CompensateTransaction operation/method
 */
if ($compensate->CompensateTransaction(new \patest\StructType\CompensateTransaction_Request()) !== false) {
    print_r($compensate->getResult());
} else {
    print_r($compensate->getLastError());
}
/**
 * Samples for Discard ServiceType
 */
$discard = new \patest\ServiceType\Discard($options);
$discard->setSoapHeaderContext(new \patest\StructType\Context());
$discard->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for DiscardTransaction operation/method
 */
if ($discard->DiscardTransaction(new \patest\StructType\DiscardTransaction_Request()) !== false) {
    print_r($discard->getResult());
} else {
    print_r($discard->getLastError());
}
/**
 * Sample call for DiscardBasketItems operation/method
 */
if ($discard->DiscardBasketItems(new \patest\StructType\DiscardBasketItems_Request()) !== false) {
    print_r($discard->getResult());
} else {
    print_r($discard->getLastError());
}
/**
 * Sample call for DiscardHospitalityTickets operation/method
 */
if ($discard->DiscardHospitalityTickets(new \patest\StructType\DiscardHospitalityTickets_Request()) !== false) {
    print_r($discard->getResult());
} else {
    print_r($discard->getLastError());
}
/**
 * Sample call for DiscardHospitalitySubscriptions operation/method
 */
if ($discard->DiscardHospitalitySubscriptions(new \patest\StructType\DiscardHospitalitySubscriptions_Request()) !== false) {
    print_r($discard->getResult());
} else {
    print_r($discard->getLastError());
}
/**
 * Samples for Put ServiceType
 */
$put = new \patest\ServiceType\Put($options);
$put->setSoapHeaderContext(new \patest\StructType\Context());
$put->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for PutTransactionOnHold operation/method
 */
if ($put->PutTransactionOnHold(new \patest\StructType\PutTransactionOnHold_Request()) !== false) {
    print_r($put->getResult());
} else {
    print_r($put->getLastError());
}
/**
 * Samples for Return ServiceType
 */
$return = new \patest\ServiceType\_Return($options);
$return->setSoapHeaderContext(new \patest\StructType\Context());
$return->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for ReturnBasketItems operation/method
 */
if ($return->ReturnBasketItems(new \patest\StructType\ReturnBasketItems_Request()) !== false) {
    print_r($return->getResult());
} else {
    print_r($return->getLastError());
}
/**
 * Sample call for ReturnPriceModifiers operation/method
 */
if ($return->ReturnPriceModifiers(new \patest\StructType\ReturnPriceModifiers_Request()) !== false) {
    print_r($return->getResult());
} else {
    print_r($return->getLastError());
}
/**
 * Samples for Activate ServiceType
 */
$activate = new \patest\ServiceType\Activate($options);
$activate->setSoapHeaderContext(new \patest\StructType\Context());
$activate->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for ActivatePriceModifiers operation/method
 */
if ($activate->ActivatePriceModifiers(new \patest\StructType\ActivatePriceModifiers_Request()) !== false) {
    print_r($activate->getResult());
} else {
    print_r($activate->getLastError());
}
/**
 * Samples for Override ServiceType
 */
$override = new \patest\ServiceType\Override($options);
$override->setSoapHeaderContext(new \patest\StructType\Context());
$override->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for OverridePriceModifiers operation/method
 */
if ($override->OverridePriceModifiers(new \patest\StructType\OverridePriceModifiers_Request()) !== false) {
    print_r($override->getResult());
} else {
    print_r($override->getLastError());
}
/**
 * Samples for Exchange ServiceType
 */
$exchange = new \patest\ServiceType\Exchange($options);
$exchange->setSoapHeaderContext(new \patest\StructType\Context());
$exchange->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for ExchangeAmounts operation/method
 */
if ($exchange->ExchangeAmounts(new \patest\StructType\ExchangeAmounts_Request()) !== false) {
    print_r($exchange->getResult());
} else {
    print_r($exchange->getLastError());
}
/**
 * Samples for Reapply ServiceType
 */
$reapply = new \patest\ServiceType\Reapply($options);
$reapply->setSoapHeaderContext(new \patest\StructType\Context());
$reapply->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for ReapplyRejectedCombinations operation/method
 */
if ($reapply->ReapplyRejectedCombinations(new \patest\StructType\ReapplyRejectedCombinations_Request()) !== false) {
    print_r($reapply->getResult());
} else {
    print_r($reapply->getLastError());
}
/**
 * Samples for Analyze ServiceType
 */
$analyze = new \patest\ServiceType\Analyze($options);
$analyze->setSoapHeaderContext(new \patest\StructType\Context());
$analyze->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for AnalyzeTransactionInteractionRequirements operation/method
 */
if ($analyze->AnalyzeTransactionInteractionRequirements(new \patest\StructType\AnalyzeTransactionInteractionRequirementsRequest()) !== false) {
    print_r($analyze->getResult());
} else {
    print_r($analyze->getLastError());
}
/**
 * Samples for Deduct ServiceType
 */
$deduct = new \patest\ServiceType\Deduct($options);
$deduct->setSoapHeaderContext(new \patest\StructType\Context());
$deduct->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for Deduct operation/method
 */
if ($deduct->Deduct(new \patest\StructType\DeductRequest()) !== false) {
    print_r($deduct->getResult());
} else {
    print_r($deduct->getLastError());
}
/**
 * Samples for Cancel ServiceType
 */
$cancel = new \patest\ServiceType\Cancel($options);
$cancel->setSoapHeaderContext(new \patest\StructType\Context());
$cancel->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for CancelDeduct operation/method
 */
if ($cancel->CancelDeduct(new \patest\StructType\CancelDeductRequest()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for CancelEventReservations operation/method
 */
if ($cancel->CancelEventReservations(new \patest\StructType\CancelEventReservations_Request()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for CancelResaleTransferTransactions operation/method
 */
if ($cancel->CancelResaleTransferTransactions(new \patest\StructType\CancelResaleTransferTransactionsRequest_Request()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for CancelReservationsInTicketScheme operation/method
 */
if ($cancel->CancelReservationsInTicketScheme(new \patest\StructType\CancelReservationsInTicketScheme_Request()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Sample call for CancelPartyByTicketIds operation/method
 */
if ($cancel->CancelPartyByTicketIds(new \patest\StructType\CancelPartyByTicketIds_Request()) !== false) {
    print_r($cancel->getResult());
} else {
    print_r($cancel->getLastError());
}
/**
 * Samples for Calculate ServiceType
 */
$calculate = new \patest\ServiceType\Calculate($options);
$calculate->setSoapHeaderContext(new \patest\StructType\Context());
$calculate->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for CalculateDefaultInvoiceDueDate operation/method
 */
if ($calculate->CalculateDefaultInvoiceDueDate(new \patest\StructType\CalculateDefaultInvoiceDueDateRequest()) !== false) {
    print_r($calculate->getResult());
} else {
    print_r($calculate->getLastError());
}
/**
 * Samples for Simulate ServiceType
 */
$simulate = new \patest\ServiceType\Simulate($options);
$simulate->setSoapHeaderContext(new \patest\StructType\Context());
$simulate->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for SimulateBasketItemsConfirmation operation/method
 */
if ($simulate->SimulateBasketItemsConfirmation(new \patest\StructType\SimulateBasketItemsConfirmation_Request()) !== false) {
    print_r($simulate->getResult());
} else {
    print_r($simulate->getLastError());
}
/**
 * Samples for Are ServiceType
 */
$are = new \patest\ServiceType\Are($options);
$are->setSoapHeaderContext(new \patest\StructType\Context());
$are->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for AreBasePricesMandatoryForPriceList operation/method
 */
if ($are->AreBasePricesMandatoryForPriceList(new \patest\StructType\AreBasePricesMandatoryForPriceListRequest()) !== false) {
    print_r($are->getResult());
} else {
    print_r($are->getLastError());
}
/**
 * Samples for Persist ServiceType
 */
$persist = new \patest\ServiceType\Persist($options);
$persist->setSoapHeaderContext(new \patest\StructType\Context());
$persist->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for PersistUserAcknowledgementReactions operation/method
 */
if ($persist->PersistUserAcknowledgementReactions(new \patest\StructType\PersistUserAcknowledgementReactionsRequest()) !== false) {
    print_r($persist->getResult());
} else {
    print_r($persist->getLastError());
}
/**
 * Samples for Connect ServiceType
 */
$connect = new \patest\ServiceType\Connect($options);
$connect->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for Connect operation/method
 */
if ($connect->Connect(new \patest\StructType\Connect_Request()) !== false) {
    print_r($connect->getResult());
} else {
    print_r($connect->getLastError());
}
/**
 * Sample call for ConnectWithJWT operation/method
 */
if ($connect->ConnectWithJWT(new \patest\StructType\ConnectWithJWT_Request()) !== false) {
    print_r($connect->getResult());
} else {
    print_r($connect->getLastError());
}
/**
 * Sample call for ConnectWithOTP operation/method
 */
if ($connect->ConnectWithOTP(new \patest\StructType\ConnectWithOTP_Request()) !== false) {
    print_r($connect->getResult());
} else {
    print_r($connect->getLastError());
}
/**
 * Sample call for ConnectWithContextToken operation/method
 */
if ($connect->ConnectWithContextToken(new \patest\StructType\ConnectWithContextToken_Request()) !== false) {
    print_r($connect->getResult());
} else {
    print_r($connect->getLastError());
}
/**
 * Samples for Extended ServiceType
 */
$extended = new \patest\ServiceType\Extended($options);
$extended->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for ExtendedConnect operation/method
 */
if ($extended->ExtendedConnect(new \patest\StructType\ExtendedConnect_Request()) !== false) {
    print_r($extended->getResult());
} else {
    print_r($extended->getLastError());
}
/**
 * Samples for Disconnect ServiceType
 */
$disconnect = new \patest\ServiceType\Disconnect($options);
$disconnect->setSoapHeaderContext(new \patest\StructType\Context());
$disconnect->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for Disconnect operation/method
 */
if ($disconnect->Disconnect(new \patest\StructType\Disconnect_Request()) !== false) {
    print_r($disconnect->getResult());
} else {
    print_r($disconnect->getLastError());
}
/**
 * Samples for Duplicate ServiceType
 */
$duplicate = new \patest\ServiceType\Duplicate($options);
$duplicate->setSoapHeaderContext(new \patest\StructType\Context());
$duplicate->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for DuplicateContext operation/method
 */
if ($duplicate->DuplicateContext(new \patest\StructType\DuplicateContext_Request()) !== false) {
    print_r($duplicate->getResult());
} else {
    print_r($duplicate->getLastError());
}
/**
 * Samples for Keep ServiceType
 */
$keep = new \patest\ServiceType\Keep($options);
$keep->setSoapHeaderContext(new \patest\StructType\Context());
$keep->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for KeepAlive operation/method
 */
if ($keep->KeepAlive(new \patest\StructType\KeepAlive_Request()) !== false) {
    print_r($keep->getResult());
} else {
    print_r($keep->getLastError());
}
/**
 * Samples for Bind ServiceType
 */
$bind = new \patest\ServiceType\Bind($options);
$bind->setSoapHeaderContext(new \patest\StructType\Context());
$bind->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for BindSalePointToIdentifier operation/method
 */
if ($bind->BindSalePointToIdentifier(new \patest\StructType\BindSalePointToIdentifier_Request()) !== false) {
    print_r($bind->getResult());
} else {
    print_r($bind->getLastError());
}
/**
 * Samples for Is ServiceType
 */
$is = new \patest\ServiceType\Is($options);
$is->setSoapHeaderContext(new \patest\StructType\Context());
$is->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for IsFeatureEnabled operation/method
 */
if ($is->IsFeatureEnabled(new \patest\StructType\IsFeatureEnabled_Request()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Sample call for IsEventAvailableAt operation/method
 */
if ($is->IsEventAvailableAt(new \patest\StructType\IsEventAvailableAt_Request()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Samples for Call ServiceType
 */
$call = new \patest\ServiceType\Call($options);
$call->setSoapHeaderContext(new \patest\StructType\Context());
$call->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for CallSP operation/method
 */
if ($call->CallSP(new \patest\StructType\CallSpRequest()) !== false) {
    print_r($call->getResult());
} else {
    print_r($call->getLastError());
}
/**
 * Samples for Move ServiceType
 */
$move = new \patest\ServiceType\Move($options);
$move->setSoapHeaderContext(new \patest\StructType\Context());
$move->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for MoveSubscriptionReservedSeatSelection operation/method
 */
if ($move->MoveSubscriptionReservedSeatSelection(new \patest\StructType\MoveSubscriptionReservedSeatSelectionRequest()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Sample call for MoveReservedSeatSelectionForMultipleEvents operation/method
 */
if ($move->MoveReservedSeatSelectionForMultipleEvents(new \patest\StructType\MoveReservedSeatSelectionForMultipleEvents_Request()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Sample call for MoveReservedSeatSelection operation/method
 */
if ($move->MoveReservedSeatSelection(new \patest\StructType\MoveReservedSeatSelection_Request()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Sample call for MoveAudience operation/method
 */
if ($move->MoveAudience(new \patest\StructType\MoveAudience_Request()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Samples for Prolong ServiceType
 */
$prolong = new \patest\ServiceType\Prolong($options);
$prolong->setSoapHeaderContext(new \patest\StructType\Context());
$prolong->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for ProlongExistingSubscriptions operation/method
 */
if ($prolong->ProlongExistingSubscriptions(new \patest\StructType\ProlongExistingSubscriptionsRequest()) !== false) {
    print_r($prolong->getResult());
} else {
    print_r($prolong->getLastError());
}
/**
 * Samples for Re ServiceType
 */
$re = new \patest\ServiceType\Re($options);
$re->setSoapHeaderContext(new \patest\StructType\Context());
$re->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for ReLockOrAllocateSubscriptions operation/method
 */
if ($re->ReLockOrAllocateSubscriptions(new \patest\StructType\ReLockOrAllocateSubscriptions_Request()) !== false) {
    print_r($re->getResult());
} else {
    print_r($re->getLastError());
}
/**
 * Sample call for ReLockTickets operation/method
 */
if ($re->ReLockTickets(new \patest\StructType\ReLockTickets_Request()) !== false) {
    print_r($re->getResult());
} else {
    print_r($re->getLastError());
}
/**
 * Sample call for ReLockOrAllocateTickets operation/method
 */
if ($re->ReLockOrAllocateTickets(new \patest\StructType\ReLockOrAllocateTickets_Request()) !== false) {
    print_r($re->getResult());
} else {
    print_r($re->getLastError());
}
/**
 * Samples for Relocate ServiceType
 */
$relocate = new \patest\ServiceType\Relocate($options);
$relocate->setSoapHeaderContext(new \patest\StructType\Context());
$relocate->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for RelocateSubscriptions operation/method
 */
if ($relocate->RelocateSubscriptions(new \patest\StructType\RelocateSubscriptions_Request()) !== false) {
    print_r($relocate->getResult());
} else {
    print_r($relocate->getLastError());
}
/**
 * Samples for Collect ServiceType
 */
$collect = new \patest\ServiceType\Collect($options);
$collect->setSoapHeaderContext(new \patest\StructType\Context());
$collect->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for CollectAndPrintTickets operation/method
 */
if ($collect->CollectAndPrintTickets(new \patest\StructType\CollectAndPrintTickets_Request()) !== false) {
    print_r($collect->getResult());
} else {
    print_r($collect->getLastError());
}
/**
 * Samples for Copy ServiceType
 */
$copy = new \patest\ServiceType\Copy($options);
$copy->setSoapHeaderContext(new \patest\StructType\Context());
$copy->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for CopyHallVersionDesign operation/method
 */
if ($copy->CopyHallVersionDesign(new \patest\StructType\CopyHallVersionDesign_Request()) !== false) {
    print_r($copy->getResult());
} else {
    print_r($copy->getLastError());
}
/**
 * Sample call for CopyEvent operation/method
 */
if ($copy->CopyEvent(new \patest\StructType\CopyEvent_Request()) !== false) {
    print_r($copy->getResult());
} else {
    print_r($copy->getLastError());
}
/**
 * Sample call for CopyEventProperties operation/method
 */
if ($copy->CopyEventProperties(new \patest\StructType\CopyEventProperties_Request()) !== false) {
    print_r($copy->getResult());
} else {
    print_r($copy->getLastError());
}
/**
 * Samples for Control ServiceType
 */
$control = new \patest\ServiceType\Control($options);
$control->setSoapHeaderContext(new \patest\StructType\Context());
$control->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for ControlEventManagers operation/method
 */
if ($control->ControlEventManagers(new \patest\StructType\ControlEventManagers_Request()) !== false) {
    print_r($control->getResult());
} else {
    print_r($control->getLastError());
}
/**
 * Samples for Mark ServiceType
 */
$mark = new \patest\ServiceType\Mark($options);
$mark->setSoapHeaderContext(new \patest\StructType\Context());
$mark->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for MarkTicketsForResale operation/method
 */
if ($mark->MarkTicketsForResale(new \patest\StructType\MarkTicketsForResale_Request()) !== false) {
    print_r($mark->getResult());
} else {
    print_r($mark->getLastError());
}
/**
 * Samples for Take ServiceType
 */
$take = new \patest\ServiceType\Take($options);
$take->setSoapHeaderContext(new \patest\StructType\Context());
$take->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for TakeOverTransaction operation/method
 */
if ($take->TakeOverTransaction(new \patest\StructType\TakeOverTransaction_Request()) !== false) {
    print_r($take->getResult());
} else {
    print_r($take->getLastError());
}
/**
 * Samples for Forward ServiceType
 */
$forward = new \patest\ServiceType\Forward($options);
$forward->setSoapHeaderContext(new \patest\StructType\Context());
$forward->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for ForwardTickets operation/method
 */
if ($forward->ForwardTickets(new \patest\StructType\ForwardTickets_Request()) !== false) {
    print_r($forward->getResult());
} else {
    print_r($forward->getLastError());
}
/**
 * Samples for Party ServiceType
 */
$party = new \patest\ServiceType\Party($options);
$party->setSoapHeaderContext(new \patest\StructType\Context());
$party->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for PartyClaim operation/method
 */
if ($party->PartyClaim(new \patest\StructType\PartyClaim_Request()) !== false) {
    print_r($party->getResult());
} else {
    print_r($party->getLastError());
}
/**
 * Samples for Attach ServiceType
 */
$attach = new \patest\ServiceType\Attach($options);
$attach->setSoapHeaderContext(new \patest\StructType\Context());
$attach->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for AttachTicketSchemeFulfillmentToExistingReservation
 * operation/method
 */
if ($attach->AttachTicketSchemeFulfillmentToExistingReservation(new \patest\StructType\AttachTicketSchemeFulfillmentToExistingReservation_Request()) !== false) {
    print_r($attach->getResult());
} else {
    print_r($attach->getLastError());
}
/**
 * Samples for Handle ServiceType
 */
$handle = new \patest\ServiceType\Handle($options);
$handle->setSoapHeaderContext(new \patest\StructType\Context());
$handle->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for HandleTicketDistribution operation/method
 */
if ($handle->HandleTicketDistribution(new \patest\StructType\HandleTicketDistribution_Request()) !== false) {
    print_r($handle->getResult());
} else {
    print_r($handle->getLastError());
}
/**
 * Samples for Export ServiceType
 */
$export = new \patest\ServiceType\Export($options);
$export->setSoapHeaderContext(new \patest\StructType\Context());
$export->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for ExportAccessCodes operation/method
 */
if ($export->ExportAccessCodes(new \patest\StructType\ExportAccessCodes_Request()) !== false) {
    print_r($export->getResult());
} else {
    print_r($export->getLastError());
}
/**
 * Samples for Deactivate ServiceType
 */
$deactivate = new \patest\ServiceType\Deactivate($options);
$deactivate->setSoapHeaderContext(new \patest\StructType\Context());
$deactivate->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for DeactivateUnusedAccessCodesAsync operation/method
 */
if ($deactivate->DeactivateUnusedAccessCodesAsync(new \patest\StructType\DeactivateUnusedAccessCodes_Request()) !== false) {
    print_r($deactivate->getResult());
} else {
    print_r($deactivate->getLastError());
}
/**
 * Sample call for DeactivateAccessCodes operation/method
 */
if ($deactivate->DeactivateAccessCodes(new \patest\StructType\DeactivateAccessCode_Request()) !== false) {
    print_r($deactivate->getResult());
} else {
    print_r($deactivate->getLastError());
}
/**
 * Samples for Upload ServiceType
 */
$upload = new \patest\ServiceType\Upload($options);
$upload->setSoapHeaderContext(new \patest\StructType\Context());
$upload->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for UploadTicketViewConfigurationImage operation/method
 */
if ($upload->UploadTicketViewConfigurationImage(new \patest\StructType\UploadTicketViewConfigurationImageRequest()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Samples for Bulk ServiceType
 */
$bulk = new \patest\ServiceType\Bulk($options);
$bulk->setSoapHeaderContext(new \patest\StructType\Context());
$bulk->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for BulkEventOwnership operation/method
 */
if ($bulk->BulkEventOwnership(new \patest\StructType\BulkEventOwnership_Request()) !== false) {
    print_r($bulk->getResult());
} else {
    print_r($bulk->getLastError());
}
/**
 * Sample call for BulkEventOwnershipV2 operation/method
 */
if ($bulk->BulkEventOwnershipV2(new \patest\StructType\BulkEventOwnership_Request()) !== false) {
    print_r($bulk->getResult());
} else {
    print_r($bulk->getLastError());
}
/**
 * Samples for Edit ServiceType
 */
$edit = new \patest\ServiceType\Edit($options);
$edit->setSoapHeaderContext(new \patest\StructType\Context());
$edit->setSoapHeaderSroBusinessFlow(new \patest\StructType\SroBusinessFlow());
/**
 * Sample call for EditBallotApplication operation/method
 */
if ($edit->EditBallotApplication(new \patest\StructType\EditBallotApplication_Request()) !== false) {
    print_r($edit->getResult());
} else {
    print_r($edit->getLastError());
}
