<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WithdrawPendingTransferTickets-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WithdrawPendingTransferTickets-Response
 * @subpackage Structs
 */
class WithdrawPendingTransferTickets_Response extends AbstractStructBase
{
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The HttpStatusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $HttpStatusCode;
    /**
     * Constructor method for WithdrawPendingTransferTickets-Response
     * @uses WithdrawPendingTransferTickets_Response::setErrorMessage()
     * @uses WithdrawPendingTransferTickets_Response::setHttpStatusCode()
     * @param string $errorMessage
     * @param int $httpStatusCode
     */
    public function __construct($errorMessage = null, $httpStatusCode = null)
    {
        $this
            ->setErrorMessage($errorMessage)
            ->setHttpStatusCode($httpStatusCode);
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \patest\StructType\WithdrawPendingTransferTickets_Response
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get HttpStatusCode value
     * @return int|null
     */
    public function getHttpStatusCode()
    {
        return $this->HttpStatusCode;
    }
    /**
     * Set HttpStatusCode value
     * @param int $httpStatusCode
     * @return \patest\StructType\WithdrawPendingTransferTickets_Response
     */
    public function setHttpStatusCode($httpStatusCode = null)
    {
        // validation for constraint: int
        if (!is_null($httpStatusCode) && !(is_int($httpStatusCode) || ctype_digit($httpStatusCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($httpStatusCode, true), gettype($httpStatusCode)), __LINE__);
        }
        $this->HttpStatusCode = $httpStatusCode;
        return $this;
    }
}
