<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WithdrawDepositsToBasket-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WithdrawDepositsToBasket-Request
 * @subpackage Structs
 */
class WithdrawDepositsToBasket_Request extends ExtensibleDataContract
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $Amount;
    /**
     * The AmountsReferenceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AmountsReferenceId;
    /**
     * The DepositCategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DepositCategoryId;
    /**
     * The DepositIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $DepositIds;
    /**
     * The ExpectedTotalPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ExpectedTotalPrice;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The ProviderSpecificData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringstring
     */
    public $ProviderSpecificData;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * Constructor method for WithdrawDepositsToBasket-Request
     * @uses WithdrawDepositsToBasket_Request::setAmount()
     * @uses WithdrawDepositsToBasket_Request::setAmountsReferenceId()
     * @uses WithdrawDepositsToBasket_Request::setDepositCategoryId()
     * @uses WithdrawDepositsToBasket_Request::setDepositIds()
     * @uses WithdrawDepositsToBasket_Request::setExpectedTotalPrice()
     * @uses WithdrawDepositsToBasket_Request::setPaymentMethodId()
     * @uses WithdrawDepositsToBasket_Request::setProviderSpecificData()
     * @uses WithdrawDepositsToBasket_Request::setTransactionGuid()
     * @uses WithdrawDepositsToBasket_Request::setTransactionSnapshotType()
     * @uses WithdrawDepositsToBasket_Request::setClientId()
     * @param \patest\StructType\Money $amount
     * @param string $amountsReferenceId
     * @param string $depositCategoryId
     * @param \patest\ArrayType\ArrayOfguid $depositIds
     * @param \patest\StructType\Money $expectedTotalPrice
     * @param string $paymentMethodId
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $providerSpecificData
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     * @param string $clientId
     */
    public function __construct(\patest\StructType\Money $amount = null, $amountsReferenceId = null, $depositCategoryId = null, \patest\ArrayType\ArrayOfguid $depositIds = null, \patest\StructType\Money $expectedTotalPrice = null, $paymentMethodId = null, \patest\ArrayType\ArrayOfKeyValueOfstringstring $providerSpecificData = null, $transactionGuid = null, $transactionSnapshotType = null, $clientId = null)
    {
        $this
            ->setAmount($amount)
            ->setAmountsReferenceId($amountsReferenceId)
            ->setDepositCategoryId($depositCategoryId)
            ->setDepositIds($depositIds)
            ->setExpectedTotalPrice($expectedTotalPrice)
            ->setPaymentMethodId($paymentMethodId)
            ->setProviderSpecificData($providerSpecificData)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType)
            ->setClientId($clientId);
    }
    /**
     * Get Amount value
     * @return \patest\StructType\Money|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \patest\StructType\Money $amount
     * @return \patest\StructType\WithdrawDepositsToBasket_Request
     */
    public function setAmount(\patest\StructType\Money $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get AmountsReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAmountsReferenceId()
    {
        return isset($this->AmountsReferenceId) ? $this->AmountsReferenceId : null;
    }
    /**
     * Set AmountsReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $amountsReferenceId
     * @return \patest\StructType\WithdrawDepositsToBasket_Request
     */
    public function setAmountsReferenceId($amountsReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($amountsReferenceId) && !is_string($amountsReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amountsReferenceId, true), gettype($amountsReferenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($amountsReferenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $amountsReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($amountsReferenceId, true)), __LINE__);
        }
        if (is_null($amountsReferenceId) || (is_array($amountsReferenceId) && empty($amountsReferenceId))) {
            unset($this->AmountsReferenceId);
        } else {
            $this->AmountsReferenceId = $amountsReferenceId;
        }
        return $this;
    }
    /**
     * Get DepositCategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepositCategoryId()
    {
        return isset($this->DepositCategoryId) ? $this->DepositCategoryId : null;
    }
    /**
     * Set DepositCategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $depositCategoryId
     * @return \patest\StructType\WithdrawDepositsToBasket_Request
     */
    public function setDepositCategoryId($depositCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($depositCategoryId) && !is_string($depositCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositCategoryId, true), gettype($depositCategoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($depositCategoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $depositCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($depositCategoryId, true)), __LINE__);
        }
        if (is_null($depositCategoryId) || (is_array($depositCategoryId) && empty($depositCategoryId))) {
            unset($this->DepositCategoryId);
        } else {
            $this->DepositCategoryId = $depositCategoryId;
        }
        return $this;
    }
    /**
     * Get DepositIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getDepositIds()
    {
        return isset($this->DepositIds) ? $this->DepositIds : null;
    }
    /**
     * Set DepositIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $depositIds
     * @return \patest\StructType\WithdrawDepositsToBasket_Request
     */
    public function setDepositIds(\patest\ArrayType\ArrayOfguid $depositIds = null)
    {
        if (is_null($depositIds) || (is_array($depositIds) && empty($depositIds))) {
            unset($this->DepositIds);
        } else {
            $this->DepositIds = $depositIds;
        }
        return $this;
    }
    /**
     * Get ExpectedTotalPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getExpectedTotalPrice()
    {
        return isset($this->ExpectedTotalPrice) ? $this->ExpectedTotalPrice : null;
    }
    /**
     * Set ExpectedTotalPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $expectedTotalPrice
     * @return \patest\StructType\WithdrawDepositsToBasket_Request
     */
    public function setExpectedTotalPrice(\patest\StructType\Money $expectedTotalPrice = null)
    {
        if (is_null($expectedTotalPrice) || (is_array($expectedTotalPrice) && empty($expectedTotalPrice))) {
            unset($this->ExpectedTotalPrice);
        } else {
            $this->ExpectedTotalPrice = $expectedTotalPrice;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return $this->PaymentMethodId;
    }
    /**
     * Set PaymentMethodId value
     * @param string $paymentMethodId
     * @return \patest\StructType\WithdrawDepositsToBasket_Request
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        $this->PaymentMethodId = $paymentMethodId;
        return $this;
    }
    /**
     * Get ProviderSpecificData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringstring|null
     */
    public function getProviderSpecificData()
    {
        return isset($this->ProviderSpecificData) ? $this->ProviderSpecificData : null;
    }
    /**
     * Set ProviderSpecificData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $providerSpecificData
     * @return \patest\StructType\WithdrawDepositsToBasket_Request
     */
    public function setProviderSpecificData(\patest\ArrayType\ArrayOfKeyValueOfstringstring $providerSpecificData = null)
    {
        if (is_null($providerSpecificData) || (is_array($providerSpecificData) && empty($providerSpecificData))) {
            unset($this->ProviderSpecificData);
        } else {
            $this->ProviderSpecificData = $providerSpecificData;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\WithdrawDepositsToBasket_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\WithdrawDepositsToBasket_Request
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\WithdrawDepositsToBasket_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
}
