<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VersionDesign StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:VersionDesign
 * @subpackage Structs
 */
class VersionDesign extends AbstractStructBase
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The BackgroundImageIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $BackgroundImageIds;
    /**
     * The DefaultAreaGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultAreaGuid;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The ImageUris
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfintstring
     */
    public $ImageUris;
    /**
     * The MaxSeatsViewInHallLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaxSeatsViewInHallLevel;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Notes;
    /**
     * The ParentHallGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ParentHallGuid;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The VersionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VersionGuid;
    /**
     * The ViewSeatsInHallLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ViewSeatsInHallLevel;
    /**
     * The ViewXaml
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ViewXaml;
    /**
     * Constructor method for VersionDesign
     * @uses VersionDesign::setActive()
     * @uses VersionDesign::setBackgroundImageIds()
     * @uses VersionDesign::setDefaultAreaGuid()
     * @uses VersionDesign::setEventId()
     * @uses VersionDesign::setImageUris()
     * @uses VersionDesign::setMaxSeatsViewInHallLevel()
     * @uses VersionDesign::setName()
     * @uses VersionDesign::setNotes()
     * @uses VersionDesign::setParentHallGuid()
     * @uses VersionDesign::setStatus()
     * @uses VersionDesign::setVersionGuid()
     * @uses VersionDesign::setViewSeatsInHallLevel()
     * @uses VersionDesign::setViewXaml()
     * @param bool $active
     * @param \patest\ArrayType\ArrayOfint $backgroundImageIds
     * @param string $defaultAreaGuid
     * @param string $eventId
     * @param \patest\ArrayType\ArrayOfKeyValueOfintstring $imageUris
     * @param int $maxSeatsViewInHallLevel
     * @param \patest\StructType\GlobalString $name
     * @param \patest\StructType\GlobalString $notes
     * @param string $parentHallGuid
     * @param string $status
     * @param string $versionGuid
     * @param bool $viewSeatsInHallLevel
     * @param string $viewXaml
     */
    public function __construct($active = null, \patest\ArrayType\ArrayOfint $backgroundImageIds = null, $defaultAreaGuid = null, $eventId = null, \patest\ArrayType\ArrayOfKeyValueOfintstring $imageUris = null, $maxSeatsViewInHallLevel = null, \patest\StructType\GlobalString $name = null, \patest\StructType\GlobalString $notes = null, $parentHallGuid = null, $status = null, $versionGuid = null, $viewSeatsInHallLevel = null, $viewXaml = null)
    {
        $this
            ->setActive($active)
            ->setBackgroundImageIds($backgroundImageIds)
            ->setDefaultAreaGuid($defaultAreaGuid)
            ->setEventId($eventId)
            ->setImageUris($imageUris)
            ->setMaxSeatsViewInHallLevel($maxSeatsViewInHallLevel)
            ->setName($name)
            ->setNotes($notes)
            ->setParentHallGuid($parentHallGuid)
            ->setStatus($status)
            ->setVersionGuid($versionGuid)
            ->setViewSeatsInHallLevel($viewSeatsInHallLevel)
            ->setViewXaml($viewXaml);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \patest\StructType\VersionDesign
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get BackgroundImageIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getBackgroundImageIds()
    {
        return isset($this->BackgroundImageIds) ? $this->BackgroundImageIds : null;
    }
    /**
     * Set BackgroundImageIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $backgroundImageIds
     * @return \patest\StructType\VersionDesign
     */
    public function setBackgroundImageIds(\patest\ArrayType\ArrayOfint $backgroundImageIds = null)
    {
        if (is_null($backgroundImageIds) || (is_array($backgroundImageIds) && empty($backgroundImageIds))) {
            unset($this->BackgroundImageIds);
        } else {
            $this->BackgroundImageIds = $backgroundImageIds;
        }
        return $this;
    }
    /**
     * Get DefaultAreaGuid value
     * @return string|null
     */
    public function getDefaultAreaGuid()
    {
        return $this->DefaultAreaGuid;
    }
    /**
     * Set DefaultAreaGuid value
     * @param string $defaultAreaGuid
     * @return \patest\StructType\VersionDesign
     */
    public function setDefaultAreaGuid($defaultAreaGuid = null)
    {
        // validation for constraint: string
        if (!is_null($defaultAreaGuid) && !is_string($defaultAreaGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultAreaGuid, true), gettype($defaultAreaGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultAreaGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultAreaGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultAreaGuid, true)), __LINE__);
        }
        $this->DefaultAreaGuid = $defaultAreaGuid;
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\VersionDesign
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get ImageUris value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfintstring|null
     */
    public function getImageUris()
    {
        return isset($this->ImageUris) ? $this->ImageUris : null;
    }
    /**
     * Set ImageUris value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfintstring $imageUris
     * @return \patest\StructType\VersionDesign
     */
    public function setImageUris(\patest\ArrayType\ArrayOfKeyValueOfintstring $imageUris = null)
    {
        if (is_null($imageUris) || (is_array($imageUris) && empty($imageUris))) {
            unset($this->ImageUris);
        } else {
            $this->ImageUris = $imageUris;
        }
        return $this;
    }
    /**
     * Get MaxSeatsViewInHallLevel value
     * @return int|null
     */
    public function getMaxSeatsViewInHallLevel()
    {
        return $this->MaxSeatsViewInHallLevel;
    }
    /**
     * Set MaxSeatsViewInHallLevel value
     * @param int $maxSeatsViewInHallLevel
     * @return \patest\StructType\VersionDesign
     */
    public function setMaxSeatsViewInHallLevel($maxSeatsViewInHallLevel = null)
    {
        // validation for constraint: int
        if (!is_null($maxSeatsViewInHallLevel) && !(is_int($maxSeatsViewInHallLevel) || ctype_digit($maxSeatsViewInHallLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxSeatsViewInHallLevel, true), gettype($maxSeatsViewInHallLevel)), __LINE__);
        }
        $this->MaxSeatsViewInHallLevel = $maxSeatsViewInHallLevel;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\VersionDesign
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $notes
     * @return \patest\StructType\VersionDesign
     */
    public function setNotes(\patest\StructType\GlobalString $notes = null)
    {
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get ParentHallGuid value
     * @return string|null
     */
    public function getParentHallGuid()
    {
        return $this->ParentHallGuid;
    }
    /**
     * Set ParentHallGuid value
     * @param string $parentHallGuid
     * @return \patest\StructType\VersionDesign
     */
    public function setParentHallGuid($parentHallGuid = null)
    {
        // validation for constraint: string
        if (!is_null($parentHallGuid) && !is_string($parentHallGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentHallGuid, true), gettype($parentHallGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($parentHallGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $parentHallGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($parentHallGuid, true)), __LINE__);
        }
        $this->ParentHallGuid = $parentHallGuid;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \patest\EnumType\HallVersionStatus::valueIsValid()
     * @uses \patest\EnumType\HallVersionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\VersionDesign
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\HallVersionStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\HallVersionStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\HallVersionStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get VersionGuid value
     * @return string|null
     */
    public function getVersionGuid()
    {
        return $this->VersionGuid;
    }
    /**
     * Set VersionGuid value
     * @param string $versionGuid
     * @return \patest\StructType\VersionDesign
     */
    public function setVersionGuid($versionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($versionGuid) && !is_string($versionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($versionGuid, true), gettype($versionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($versionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $versionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($versionGuid, true)), __LINE__);
        }
        $this->VersionGuid = $versionGuid;
        return $this;
    }
    /**
     * Get ViewSeatsInHallLevel value
     * @return bool|null
     */
    public function getViewSeatsInHallLevel()
    {
        return $this->ViewSeatsInHallLevel;
    }
    /**
     * Set ViewSeatsInHallLevel value
     * @param bool $viewSeatsInHallLevel
     * @return \patest\StructType\VersionDesign
     */
    public function setViewSeatsInHallLevel($viewSeatsInHallLevel = null)
    {
        // validation for constraint: boolean
        if (!is_null($viewSeatsInHallLevel) && !is_bool($viewSeatsInHallLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($viewSeatsInHallLevel, true), gettype($viewSeatsInHallLevel)), __LINE__);
        }
        $this->ViewSeatsInHallLevel = $viewSeatsInHallLevel;
        return $this;
    }
    /**
     * Get ViewXaml value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getViewXaml()
    {
        return isset($this->ViewXaml) ? $this->ViewXaml : null;
    }
    /**
     * Set ViewXaml value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $viewXaml
     * @return \patest\StructType\VersionDesign
     */
    public function setViewXaml($viewXaml = null)
    {
        // validation for constraint: string
        if (!is_null($viewXaml) && !is_string($viewXaml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($viewXaml, true), gettype($viewXaml)), __LINE__);
        }
        if (is_null($viewXaml) || (is_array($viewXaml) && empty($viewXaml))) {
            unset($this->ViewXaml);
        } else {
            $this->ViewXaml = $viewXaml;
        }
        return $this;
    }
}
