<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerifyAndSaveDeviceIdsResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:VerifyAndSaveDeviceIdsResponse
 * @subpackage Structs
 */
class VerifyAndSaveDeviceIdsResponse extends AbstractStructBase
{
    /**
     * The ErrCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrCode;
    /**
     * The ErrMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrMessage;
    /**
     * The Success
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Success;
    /**
     * Constructor method for VerifyAndSaveDeviceIdsResponse
     * @uses VerifyAndSaveDeviceIdsResponse::setErrCode()
     * @uses VerifyAndSaveDeviceIdsResponse::setErrMessage()
     * @uses VerifyAndSaveDeviceIdsResponse::setSuccess()
     * @param int $errCode
     * @param string $errMessage
     * @param bool $success
     */
    public function __construct($errCode = null, $errMessage = null, $success = null)
    {
        $this
            ->setErrCode($errCode)
            ->setErrMessage($errMessage)
            ->setSuccess($success);
    }
    /**
     * Get ErrCode value
     * @return int|null
     */
    public function getErrCode()
    {
        return $this->ErrCode;
    }
    /**
     * Set ErrCode value
     * @param int $errCode
     * @return \patest\StructType\VerifyAndSaveDeviceIdsResponse
     */
    public function setErrCode($errCode = null)
    {
        // validation for constraint: int
        if (!is_null($errCode) && !(is_int($errCode) || ctype_digit($errCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errCode, true), gettype($errCode)), __LINE__);
        }
        $this->ErrCode = $errCode;
        return $this;
    }
    /**
     * Get ErrMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrMessage()
    {
        return isset($this->ErrMessage) ? $this->ErrMessage : null;
    }
    /**
     * Set ErrMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errMessage
     * @return \patest\StructType\VerifyAndSaveDeviceIdsResponse
     */
    public function setErrMessage($errMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errMessage) && !is_string($errMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errMessage, true), gettype($errMessage)), __LINE__);
        }
        if (is_null($errMessage) || (is_array($errMessage) && empty($errMessage))) {
            unset($this->ErrMessage);
        } else {
            $this->ErrMessage = $errMessage;
        }
        return $this;
    }
    /**
     * Get Success value
     * @return bool|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param bool $success
     * @return \patest\StructType\VerifyAndSaveDeviceIdsResponse
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->Success = $success;
        return $this;
    }
}
