<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateTransaction-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidateTransaction-Request
 * @subpackage Structs
 */
class ValidateTransaction_Request extends ExtensibleDataContract
{
    /**
     * The OmitBalanceValidation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $OmitBalanceValidation;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The ChangedTransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ChangedTransactionSnapshotType;
    /**
     * The ExpectNotFullyPaid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ExpectNotFullyPaid;
    /**
     * Constructor method for ValidateTransaction-Request
     * @uses ValidateTransaction_Request::setOmitBalanceValidation()
     * @uses ValidateTransaction_Request::setTransactionGuid()
     * @uses ValidateTransaction_Request::setChangedTransactionSnapshotType()
     * @uses ValidateTransaction_Request::setExpectNotFullyPaid()
     * @param bool $omitBalanceValidation
     * @param string $transactionGuid
     * @param string $changedTransactionSnapshotType
     * @param bool $expectNotFullyPaid
     */
    public function __construct($omitBalanceValidation = null, $transactionGuid = null, $changedTransactionSnapshotType = null, $expectNotFullyPaid = null)
    {
        $this
            ->setOmitBalanceValidation($omitBalanceValidation)
            ->setTransactionGuid($transactionGuid)
            ->setChangedTransactionSnapshotType($changedTransactionSnapshotType)
            ->setExpectNotFullyPaid($expectNotFullyPaid);
    }
    /**
     * Get OmitBalanceValidation value
     * @return bool|null
     */
    public function getOmitBalanceValidation()
    {
        return $this->OmitBalanceValidation;
    }
    /**
     * Set OmitBalanceValidation value
     * @param bool $omitBalanceValidation
     * @return \patest\StructType\ValidateTransaction_Request
     */
    public function setOmitBalanceValidation($omitBalanceValidation = null)
    {
        // validation for constraint: boolean
        if (!is_null($omitBalanceValidation) && !is_bool($omitBalanceValidation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($omitBalanceValidation, true), gettype($omitBalanceValidation)), __LINE__);
        }
        $this->OmitBalanceValidation = $omitBalanceValidation;
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\ValidateTransaction_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get ChangedTransactionSnapshotType value
     * @return string|null
     */
    public function getChangedTransactionSnapshotType()
    {
        return $this->ChangedTransactionSnapshotType;
    }
    /**
     * Set ChangedTransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $changedTransactionSnapshotType
     * @return \patest\StructType\ValidateTransaction_Request
     */
    public function setChangedTransactionSnapshotType($changedTransactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($changedTransactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($changedTransactionSnapshotType) ? implode(', ', $changedTransactionSnapshotType) : var_export($changedTransactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->ChangedTransactionSnapshotType = $changedTransactionSnapshotType;
        return $this;
    }
    /**
     * Get ExpectNotFullyPaid value
     * @return bool|null
     */
    public function getExpectNotFullyPaid()
    {
        return $this->ExpectNotFullyPaid;
    }
    /**
     * Set ExpectNotFullyPaid value
     * @param bool $expectNotFullyPaid
     * @return \patest\StructType\ValidateTransaction_Request
     */
    public function setExpectNotFullyPaid($expectNotFullyPaid = null)
    {
        // validation for constraint: boolean
        if (!is_null($expectNotFullyPaid) && !is_bool($expectNotFullyPaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expectNotFullyPaid, true), gettype($expectNotFullyPaid)), __LINE__);
        }
        $this->ExpectNotFullyPaid = $expectNotFullyPaid;
        return $this;
    }
}
