<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateSelectedProductsForBundleResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidateSelectedProductsForBundleResponse
 * @subpackage Structs
 */
class ValidateSelectedProductsForBundleResponse extends ExtensibleDataContract
{
    /**
     * The IsValid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsValid;
    /**
     * The ValidationDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfBundleElementValidationDetails
     */
    public $ValidationDetails;
    /**
     * Constructor method for ValidateSelectedProductsForBundleResponse
     * @uses ValidateSelectedProductsForBundleResponse::setIsValid()
     * @uses ValidateSelectedProductsForBundleResponse::setValidationDetails()
     * @param bool $isValid
     * @param \patest\ArrayType\ArrayOfBundleElementValidationDetails $validationDetails
     */
    public function __construct($isValid = null, \patest\ArrayType\ArrayOfBundleElementValidationDetails $validationDetails = null)
    {
        $this
            ->setIsValid($isValid)
            ->setValidationDetails($validationDetails);
    }
    /**
     * Get IsValid value
     * @return bool|null
     */
    public function getIsValid()
    {
        return $this->IsValid;
    }
    /**
     * Set IsValid value
     * @param bool $isValid
     * @return \patest\StructType\ValidateSelectedProductsForBundleResponse
     */
    public function setIsValid($isValid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValid) && !is_bool($isValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isValid, true), gettype($isValid)), __LINE__);
        }
        $this->IsValid = $isValid;
        return $this;
    }
    /**
     * Get ValidationDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfBundleElementValidationDetails|null
     */
    public function getValidationDetails()
    {
        return isset($this->ValidationDetails) ? $this->ValidationDetails : null;
    }
    /**
     * Set ValidationDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfBundleElementValidationDetails $validationDetails
     * @return \patest\StructType\ValidateSelectedProductsForBundleResponse
     */
    public function setValidationDetails(\patest\ArrayType\ArrayOfBundleElementValidationDetails $validationDetails = null)
    {
        if (is_null($validationDetails) || (is_array($validationDetails) && empty($validationDetails))) {
            unset($this->ValidationDetails);
        } else {
            $this->ValidationDetails = $validationDetails;
        }
        return $this;
    }
}
