<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateBarcode-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidateBarcode-Request
 * @subpackage Structs
 */
class ValidateBarcode_Request extends ExtensibleDataContract
{
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The ScannerId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ScannerId;
    /**
     * Constructor method for ValidateBarcode-Request
     * @uses ValidateBarcode_Request::setBarcode()
     * @uses ValidateBarcode_Request::setScannerId()
     * @param string $barcode
     * @param string $scannerId
     */
    public function __construct($barcode = null, $scannerId = null)
    {
        $this
            ->setBarcode($barcode)
            ->setScannerId($scannerId);
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\ValidateBarcode_Request
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get ScannerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScannerId()
    {
        return isset($this->ScannerId) ? $this->ScannerId : null;
    }
    /**
     * Set ScannerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scannerId
     * @return \patest\StructType\ValidateBarcode_Request
     */
    public function setScannerId($scannerId = null)
    {
        // validation for constraint: string
        if (!is_null($scannerId) && !is_string($scannerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scannerId, true), gettype($scannerId)), __LINE__);
        }
        if (is_null($scannerId) || (is_array($scannerId) && empty($scannerId))) {
            unset($this->ScannerId);
        } else {
            $this->ScannerId = $scannerId;
        }
        return $this;
    }
}
