<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateTicketViewAssociationPrioritiesByIdsRequestBase
 * StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateTicketViewAssociationPrioritiesByIdsRequestBase
 * @subpackage Structs
 */
class UpdateTicketViewAssociationPrioritiesByIdsRequestBase extends AbstractStructBase
{
    /**
     * The AssociationPriorities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfguidint
     */
    public $AssociationPriorities;
    /**
     * The PrimaryAssociationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PrimaryAssociationId;
    /**
     * The PrimaryAssociationPosition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PrimaryAssociationPosition;
    /**
     * Constructor method for UpdateTicketViewAssociationPrioritiesByIdsRequestBase
     * @uses UpdateTicketViewAssociationPrioritiesByIdsRequestBase::setAssociationPriorities()
     * @uses UpdateTicketViewAssociationPrioritiesByIdsRequestBase::setPrimaryAssociationId()
     * @uses UpdateTicketViewAssociationPrioritiesByIdsRequestBase::setPrimaryAssociationPosition()
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidint $associationPriorities
     * @param string $primaryAssociationId
     * @param int $primaryAssociationPosition
     */
    public function __construct(\patest\ArrayType\ArrayOfKeyValueOfguidint $associationPriorities = null, $primaryAssociationId = null, $primaryAssociationPosition = null)
    {
        $this
            ->setAssociationPriorities($associationPriorities)
            ->setPrimaryAssociationId($primaryAssociationId)
            ->setPrimaryAssociationPosition($primaryAssociationPosition);
    }
    /**
     * Get AssociationPriorities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfguidint|null
     */
    public function getAssociationPriorities()
    {
        return isset($this->AssociationPriorities) ? $this->AssociationPriorities : null;
    }
    /**
     * Set AssociationPriorities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidint $associationPriorities
     * @return \patest\StructType\UpdateTicketViewAssociationPrioritiesByIdsRequestBase
     */
    public function setAssociationPriorities(\patest\ArrayType\ArrayOfKeyValueOfguidint $associationPriorities = null)
    {
        if (is_null($associationPriorities) || (is_array($associationPriorities) && empty($associationPriorities))) {
            unset($this->AssociationPriorities);
        } else {
            $this->AssociationPriorities = $associationPriorities;
        }
        return $this;
    }
    /**
     * Get PrimaryAssociationId value
     * @return string|null
     */
    public function getPrimaryAssociationId()
    {
        return $this->PrimaryAssociationId;
    }
    /**
     * Set PrimaryAssociationId value
     * @param string $primaryAssociationId
     * @return \patest\StructType\UpdateTicketViewAssociationPrioritiesByIdsRequestBase
     */
    public function setPrimaryAssociationId($primaryAssociationId = null)
    {
        // validation for constraint: string
        if (!is_null($primaryAssociationId) && !is_string($primaryAssociationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryAssociationId, true), gettype($primaryAssociationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($primaryAssociationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $primaryAssociationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($primaryAssociationId, true)), __LINE__);
        }
        $this->PrimaryAssociationId = $primaryAssociationId;
        return $this;
    }
    /**
     * Get PrimaryAssociationPosition value
     * @return int|null
     */
    public function getPrimaryAssociationPosition()
    {
        return $this->PrimaryAssociationPosition;
    }
    /**
     * Set PrimaryAssociationPosition value
     * @param int $primaryAssociationPosition
     * @return \patest\StructType\UpdateTicketViewAssociationPrioritiesByIdsRequestBase
     */
    public function setPrimaryAssociationPosition($primaryAssociationPosition = null)
    {
        // validation for constraint: int
        if (!is_null($primaryAssociationPosition) && !(is_int($primaryAssociationPosition) || ctype_digit($primaryAssociationPosition))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($primaryAssociationPosition, true), gettype($primaryAssociationPosition)), __LINE__);
        }
        $this->PrimaryAssociationPosition = $primaryAssociationPosition;
        return $this;
    }
}
