<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSubscriptionInstancesMaxAllowedExchanges-Request
 * StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UpdateSubscriptionInstancesMaxAllowedExchanges-Request
 * @subpackage Structs
 */
class UpdateSubscriptionInstancesMaxAllowedExchanges_Request extends ExtensibleDataContract
{
    /**
     * The NewMaxValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NewMaxValue;
    /**
     * The SeriesIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $SeriesIds;
    /**
     * Constructor method for UpdateSubscriptionInstancesMaxAllowedExchanges-Request
     * @uses UpdateSubscriptionInstancesMaxAllowedExchanges_Request::setNewMaxValue()
     * @uses UpdateSubscriptionInstancesMaxAllowedExchanges_Request::setSeriesIds()
     * @param int $newMaxValue
     * @param \patest\ArrayType\ArrayOfguid $seriesIds
     */
    public function __construct($newMaxValue = null, \patest\ArrayType\ArrayOfguid $seriesIds = null)
    {
        $this
            ->setNewMaxValue($newMaxValue)
            ->setSeriesIds($seriesIds);
    }
    /**
     * Get NewMaxValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNewMaxValue()
    {
        return isset($this->NewMaxValue) ? $this->NewMaxValue : null;
    }
    /**
     * Set NewMaxValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $newMaxValue
     * @return \patest\StructType\UpdateSubscriptionInstancesMaxAllowedExchanges_Request
     */
    public function setNewMaxValue($newMaxValue = null)
    {
        // validation for constraint: int
        if (!is_null($newMaxValue) && !(is_int($newMaxValue) || ctype_digit($newMaxValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newMaxValue, true), gettype($newMaxValue)), __LINE__);
        }
        if (is_null($newMaxValue) || (is_array($newMaxValue) && empty($newMaxValue))) {
            unset($this->NewMaxValue);
        } else {
            $this->NewMaxValue = $newMaxValue;
        }
        return $this;
    }
    /**
     * Get SeriesIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getSeriesIds()
    {
        return isset($this->SeriesIds) ? $this->SeriesIds : null;
    }
    /**
     * Set SeriesIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $seriesIds
     * @return \patest\StructType\UpdateSubscriptionInstancesMaxAllowedExchanges_Request
     */
    public function setSeriesIds(\patest\ArrayType\ArrayOfguid $seriesIds = null)
    {
        if (is_null($seriesIds) || (is_array($seriesIds) && empty($seriesIds))) {
            unset($this->SeriesIds);
        } else {
            $this->SeriesIds = $seriesIds;
        }
        return $this;
    }
}
